<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Register Admin</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background-color: #fff;
      color: #000;
      font-family: 'Segoe UI', sans-serif;
    }

    .card {
      border: 1px solid #ccc;
      border-radius: 12px;
      box-shadow: none;
      background-color: #f9f9f9;
    }

    .form-control {
      background-color: #fff;
      color: #000;
      border-color: #000;
    }

    .form-control:focus {
      border-color: #000;
      box-shadow: none;
    }

    .btn-dark {
      background-color: #000;
      border: none;
    }

    .btn-dark:hover {
      background-color: #333;
    }

    .toggle-password {
      cursor: pointer;
      position: absolute;
      right: 15px;
      top: 38px;
      color: #555;
    }

    .text-muted-link {
      color: #444;
      font-size: 0.9rem;
    }

    .text-muted-link:hover {
      color: #000;
      text-decoration: underline;
    }
  </style>
</head>
<body>
<div class="container d-flex align-items-center justify-content-center min-vh-100">
  <div class="col-md-6 col-lg-5">

    <?php if (isset($_GET['pesan']) && $_GET['pesan'] == 'gagal'): ?>
      <div class="alert alert-danger alert-dismissible fade show" role="alert">
        Email sudah terdaftar!
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
      </div>
    <?php endif; ?>

    <div class="card p-4">
      <div class="card-body">
        <h4 class="card-title mb-4 text-center">Register Admin</h4>
        <form action="../proses/proses_admin_register.php" method="POST">
          <div class="mb-3">
            <label for="nama" class="form-label">Nama</label>
            <input type="text" name="nama" class="form-control" placeholder="Nama lengkap" required>
          </div>
          <div class="mb-3">
            <label for="email" class="form-label">Email</label>
            <input type="email" name="email" class="form-control" placeholder="admin@example.com" required>
          </div>
          <div class="mb-3 position-relative">
            <label for="password" class="form-label">Password</label>
            <input type="password" id="password" name="password" class="form-control" placeholder="Buat password" required>
            <span class="toggle-password" onclick="togglePassword()">👁</span>
          </div>
          <div class="d-grid">
            <button type="submit" class="btn btn-dark">Daftar</button>
          </div>
          <div class="mt-3 text-center">
            <a href="../login/admin_login.php" class="text-muted-link">Sudah punya akun? Login</a>
          </div>
        </form>
      </div>
    </div>

  </div>
</div>

<script>
  function togglePassword() {
    const input = document.getElementById('password');
    input.type = input.type === 'password' ? 'text' : 'password';
  }
</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
