<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Register - vedge</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Playfair Display', serif;
      background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
      min-height: 100vh;
      color: #1a1a1a;
      line-height: 1.6;
    }

    .register-container {
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 2rem 1rem;
    }

    .register-card {
      background: rgba(255, 255, 255, 0.95);
      backdrop-filter: blur(20px);
      border-radius: 24px;
      box-shadow: 0 20px 60px rgba(0, 0, 0, 0.1);
      border: 1px solid rgba(255, 255, 255, 0.2);
      max-width: 500px;
      width: 100%;
      overflow: hidden;
      transition: all 0.3s ease;
    }

    .register-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 30px 80px rgba(0, 0, 0, 0.15);
    }

    .brand-header {
      background: linear-gradient(135deg, #1a1a1a 0%, #333333 100%);
      color: white;
      padding: 2.5rem 2rem;
      text-align: center;
      position: relative;
      overflow: hidden;
    }

    .brand-header::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="white" opacity="0.1"/><circle cx="75" cy="75" r="1" fill="white" opacity="0.1"/><circle cx="50" cy="10" r="0.5" fill="white" opacity="0.1"/><circle cx="10" cy="60" r="0.5" fill="white" opacity="0.1"/><circle cx="90" cy="40" r="0.5" fill="white" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
      opacity: 0.3;
    }

    .brand-title {
      font-size: 2.5rem;
      font-weight: 800;
      margin-bottom: 0.5rem;
      position: relative;
      z-index: 1;
      letter-spacing: -0.02em;
    }

    .brand-subtitle {
      font-size: 1rem;
      font-weight: 400;
      opacity: 0.9;
      position: relative;
      z-index: 1;
      font-style: italic;
    }

    .register-body {
      padding: 2.5rem 2rem;
    }

    .welcome-text {
      text-align: center;
      margin-bottom: 2rem;
    }

    .welcome-title {
      font-size: 1.5rem;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 0.5rem;
    }

    .welcome-subtitle {
      color: #666;
      font-size: 0.95rem;
    }

    .alert {
      border-radius: 12px;
      padding: 1rem 1.5rem;
      margin-bottom: 1.5rem;
      border: none;
      font-weight: 500;
    }

    .alert-danger {
      background: linear-gradient(135deg, #fee 0%, #fcc 100%);
      color: #c53030;
      border-left: 4px solid #c53030;
    }

    .form-group {
      margin-bottom: 1.5rem;
    }

    .form-label {
      font-weight: 600;
      color: #1a1a1a;
      margin-bottom: 0.75rem;
      font-size: 0.95rem;
      text-transform: uppercase;
      letter-spacing: 0.5px;
    }

    .input-wrapper {
      position: relative;
      display: flex;
      align-items: center;
      background: white;
      border: 2px solid #e9ecef;
      border-radius: 12px;
      transition: all 0.3s ease;
      overflow: hidden;
    }

    .input-wrapper:focus-within {
      border-color: #1a1a1a;
      box-shadow: 0 0 0 3px rgba(26, 26, 26, 0.1);
    }

    .input-icon {
      padding: 1rem;
      color: #666;
      font-size: 1.1rem;
      background: #f8f9fa;
      border-right: 1px solid #e9ecef;
    }

    .form-control {
      border: none;
      padding: 1rem 1.5rem;
      font-size: 1rem;
      background: transparent;
      color: #1a1a1a;
      font-family: 'Playfair Display', serif;
      flex: 1;
    }

    .form-control:focus {
      outline: none;
      box-shadow: none;
    }

    .form-control::placeholder {
      color: #999;
      font-style: italic;
    }

    .password-toggle {
      padding: 1rem;
      background: transparent;
      border: none;
      color: #666;
      cursor: pointer;
      transition: color 0.3s ease;
    }

    .password-toggle:hover {
      color: #1a1a1a;
    }

    .form-text {
      font-size: 0.85rem;
      color: #666;
      margin-top: 0.5rem;
      font-style: italic;
    }

    .form-text i {
      margin-right: 0.5rem;
      color: #1a1a1a;
    }

    .checkbox-wrapper {
      display: flex;
      align-items: flex-start;
      gap: 0.75rem;
      margin-bottom: 1.5rem;
    }

    .form-check-input {
      margin-top: 0.25rem;
      border: 2px solid #e9ecef;
      border-radius: 4px;
      transition: all 0.3s ease;
    }

    .form-check-input:checked {
      background-color: #1a1a1a;
      border-color: #1a1a1a;
    }

    .form-check-input:focus {
      box-shadow: 0 0 0 3px rgba(26, 26, 26, 0.1);
    }

    .form-check-label {
      font-size: 0.9rem;
      color: #666;
      line-height: 1.5;
    }

    .form-check-label a {
      color: #1a1a1a;
      text-decoration: none;
      font-weight: 600;
      transition: color 0.3s ease;
    }

    .form-check-label a:hover {
      color: #000;
    }

    .btn-register {
      background: linear-gradient(135deg, #1a1a1a 0%, #333333 100%);
      color: white;
      border: none;
      border-radius: 12px;
      padding: 1rem 2rem;
      font-size: 1.1rem;
      font-weight: 600;
      text-transform: uppercase;
      letter-spacing: 0.5px;
      transition: all 0.3s ease;
      width: 100%;
      margin-bottom: 1.5rem;
    }

    .btn-register:hover {
      background: linear-gradient(135deg, #000000 0%, #1a1a1a 100%);
      transform: translateY(-2px);
      box-shadow: 0 10px 30px rgba(26, 26, 26, 0.3);
      color: white;
    }

    .divider {
      text-align: center;
      margin: 1.5rem 0;
      position: relative;
    }

    .divider::before {
      content: '';
      position: absolute;
      top: 50%;
      left: 0;
      right: 0;
      height: 1px;
      background: #e9ecef;
    }

    .divider-text {
      background: rgba(255, 255, 255, 0.95);
      padding: 0 1rem;
      color: #666;
      font-size: 0.9rem;
      font-style: italic;
    }

    .action-links {
      text-align: center;
    }

    .action-link {
      display: block;
      color: #1a1a1a;
      text-decoration: none;
      font-weight: 500;
      margin-bottom: 0.75rem;
      transition: color 0.3s ease;
    }

    .action-link:hover {
      color: #000;
    }

    .action-link.primary {
      color: #1a1a1a;
      font-weight: 600;
    }

    .footer {
      text-align: center;
      margin-top: 2rem;
      padding-top: 1.5rem;
      border-top: 1px solid #e9ecef;
    }

    .footer-text {
      color: #666;
      font-size: 0.85rem;
      font-style: italic;
    }

    .fade-in {
      animation: fadeIn 0.8s ease-out;
    }

    @keyframes fadeIn {
      from {
        opacity: 0;
        transform: translateY(30px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    @media (max-width: 768px) {
      .register-container {
        padding: 1rem;
      }

      .brand-title {
        font-size: 2rem;
      }

      .register-body {
        padding: 2rem 1.5rem;
      }

      .welcome-title {
        font-size: 1.25rem;
      }
    }

    @media (max-width: 480px) {
      .brand-header {
        padding: 2rem 1.5rem;
      }

      .brand-title {
        font-size: 1.75rem;
      }

      .register-body {
        padding: 1.5rem 1rem;
      }
    }
  </style>
</head>
<body>
  <div class="register-container">
    <div class="register-card fade-in">
      <!-- Brand Header -->
      <div class="brand-header">
        <h1 class="brand-title">vedge</h1>
        <p class="brand-subtitle">Fashion Forward Collection</p>
      </div>

      <!-- Register Body -->
      <div class="register-body">
        <!-- Welcome Text -->
        <div class="welcome-text">
          <h2 class="welcome-title">Join Our Community</h2>
          <p class="welcome-subtitle">Create your account to start shopping</p>
        </div>

        <!-- Alert Messages -->
        <div id="alert-container">
          <?php if (isset($_GET['pesan']) && $_GET['pesan'] == 'gagal'): ?>
            <div class="alert alert-danger" role="alert">
              <i class="fas fa-exclamation-circle me-2"></i>Email sudah terdaftar!
            </div>
          <?php endif; ?>
        </div>

        <!-- Register Form -->
        <form action="../vedge/proses/proses_pelanggan_register.php" method="POST" id="registerForm">
          <!-- Full Name Input -->
          <div class="form-group">
            <label for="nama" class="form-label">Full Name</label>
            <div class="input-wrapper">
              <div class="input-icon">
                <i class="fas fa-user"></i>
              </div>
              <input type="text" 
                     name="nama" 
                     id="nama"
                     class="form-control" 
                     placeholder="Enter your full name"
                     required>
            </div>
          </div>

          <!-- Email Input -->
          <div class="form-group">
            <label for="email" class="form-label">Email Address</label>
            <div class="input-wrapper">
              <div class="input-icon">
                <i class="fas fa-envelope"></i>
              </div>
              <input type="email" 
                     name="email" 
                     id="email"
                     class="form-control" 
                     placeholder="Enter your email address"
                     required>
            </div>
            <div class="form-text">
              <i class="fas fa-info-circle"></i>Please ensure your email is active
            </div>
          </div>

          <!-- Password Input -->
          <div class="form-group">
            <label for="password" class="form-label">Password</label>
            <div class="input-wrapper">
              <div class="input-icon">
                <i class="fas fa-lock"></i>
              </div>
              <input type="password" 
                     name="password" 
                     id="password"
                     class="form-control" 
                     placeholder="Create a strong password"
                     required
                     minlength="6">
              <button class="password-toggle" 
                      type="button" 
                      id="togglePassword">
                <i class="fas fa-eye" id="eyeIcon"></i>
              </button>
            </div>
            <div class="form-text">
              <i class="fas fa-shield-alt"></i>Minimum 6 characters required
            </div>
          </div>

          <!-- Terms and Conditions -->
          <div class="checkbox-wrapper">
            <input class="form-check-input" type="checkbox" id="terms" required>
            <label class="form-check-label" for="terms">
              I agree to the <a href="#">Terms & Conditions</a> and <a href="#">Privacy Policy</a>
            </label>
          </div>

          <!-- Register Button -->
          <button type="submit" class="btn btn-register">
            <i class="fas fa-user-plus me-2"></i>Create Account
          </button>
        </form>

        <!-- Divider -->
        <div class="divider">
          <span class="divider-text">or</span>
        </div>

        <!-- Action Links -->
        <div class="action-links">
          <a href="../vedge/login.php" class="action-link primary">
            Already have an account? <strong>Sign in here</strong>
          </a>
        </div>

        <!-- Footer -->
        <div class="footer">
          <p class="footer-text">© 2025 vedge. All rights reserved.</p>
        </div>
      </div>
    </div>
  </div>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

  <!-- Custom JavaScript -->
  <script>
    // Toggle Password Visibility
    document.getElementById('togglePassword').addEventListener('click', function () {
      const password = document.getElementById('password');
      const eyeIcon = document.getElementById('eyeIcon');
      
      if (password.type === 'password') {
        password.type = 'text';
        eyeIcon.classList.remove('fa-eye');
        eyeIcon.classList.add('fa-eye-slash');
      } else {
        password.type = 'password';
        eyeIcon.classList.remove('fa-eye-slash');
        eyeIcon.classList.add('fa-eye');
      }
    });

    // Form Validation Enhancement
    document.getElementById('registerForm').addEventListener('submit', function(e) {
      const password = document.getElementById('password').value;
      const terms = document.getElementById('terms').checked;
      
      if (password.length < 6) {
        e.preventDefault();
        alert('Password must be at least 6 characters long!');
        return false;
      }
      
      if (!terms) {
        e.preventDefault();
        alert('You must agree to the Terms & Conditions!');
        return false;
      }
    });

    // Auto-capitalize name input
    document.getElementById('nama').addEventListener('input', function() {
      this.value = this.value.replace(/\b\w/g, l => l.toUpperCase());
    });
  </script>
</body>
</html>