<?php
require '../config.php';
session_start();
require 'navbar.php';
if (!isset($_SESSION['user_id'])) {
  header("Location: login.php");
  exit;
}

$user_id = $_SESSION['user_id'];
$query = mysqli_query($conn, "SELECT * FROM pengguna WHERE id = $user_id");
$user = mysqli_fetch_assoc($query);

if ($user['peran'] !== 'pelanggan') {
  echo "Akses ditolak!";
  exit;
}
?>

<!DOCTYPE html>
<html>

<head>
  <title>Profil Saya - vedge</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
  <style>
    body {
      background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
      color: #1a1a1a;
      font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
      line-height: 1.6;
    }
    .profile-container {
      background: white;
      border-radius: 20px;
      box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
      padding: 50px;
      margin-bottom: 40px;
      max-width: 900px;
      margin-left: auto;
      margin-right: auto;
      border: 1px solid rgba(0, 0, 0, 0.05);
    }

    .section-header {
      display: flex;
      align-items: center;
      margin-bottom: 40px;
      padding-bottom: 20px;
      border-bottom: 2px solid #f0f0f0;
    }

    .section-header i {
      font-size: 1.5rem;
      color: #1a1a1a;
      margin-right: 15px;
      width: 40px;
      height: 40px;
      display: flex;
      align-items: center;
      justify-content: center;
      background: #f8f9fa;
      border-radius: 10px;
    }

    .section-header h2 {
      font-family: 'Playfair Display', serif;
      font-size: 1.8rem;
      font-weight: 600;
      color: #1a1a1a;
      margin: 0;
    }

    .form-group {
      margin-bottom: 25px;
    }

    label {
      color: #1a1a1a;
      font-weight: 600;
      margin-bottom: 8px;
      display: block;
      font-size: 0.95rem;
      letter-spacing: 0.3px;
    }

    .form-control {
      border: 2px solid #e9ecef;
      padding: 15px 18px;
      border-radius: 12px;
      color: #1a1a1a;
      background-color: #fff;
      font-size: 1rem;
      width: 100%;
      transition: all 0.3s ease;
      font-weight: 500;
    }

    .form-control:focus {
      border-color: #1a1a1a;
      box-shadow: 0 0 0 3px rgba(26, 26, 26, 0.1);
      outline: none;
      background-color: #fff;
    }

    .form-control::placeholder {
      color: #adb5bd;
    }

    textarea.form-control {
      resize: vertical;
      min-height: 100px;
    }

    .btn {
      padding: 15px 30px;
      border-radius: 12px;
      cursor: pointer;
      font-weight: 600;
      transition: all 0.3s ease;
      font-size: 1rem;
      border: 2px solid transparent;
      display: inline-flex;
      align-items: center;
      gap: 8px;
      text-decoration: none;
    }

    .btn-primary {
      background: linear-gradient(135deg, #1a1a1a 0%, #333 100%);
      color: white;
      border-color: #1a1a1a;
    }

    .btn-primary:hover {
      background: linear-gradient(135deg, #333 0%, #1a1a1a 100%);
      color: white;
      transform: translateY(-2px);
      box-shadow: 0 8px 25px rgba(26, 26, 26, 0.2);
    }

    .btn-outline {
      background: transparent;
      color: #1a1a1a;
      border-color: #1a1a1a;
    }

    .btn-outline:hover {
      background: #1a1a1a;
      color: white;
      transform: translateY(-2px);
      box-shadow: 0 8px 25px rgba(26, 26, 26, 0.2);
    }

    .btn-group {
      display: flex;
      gap: 15px;
      margin-top: 30px;
    }

    .modal-content {
      background: white;
      border-radius: 20px;
      box-shadow: 0 20px 60px rgba(0, 0, 0, 0.15);
      border: none;
      overflow: hidden;
    }

    .modal-header {
      background: linear-gradient(135deg, #1a1a1a 0%, #333 100%);
      color: white;
      border: none;
      padding: 25px 30px;
    }

    .modal-title {
      font-family: 'Playfair Display', serif;
      font-size: 1.3rem;
      font-weight: 600;
    }

    .modal-body {
      padding: 30px;
    }

    .modal-footer {
      border-top: 1px solid #f0f0f0;
      padding: 20px 30px;
      background: #f8f9fa;
    }

    .btn-close {
      filter: invert(1);
    }

    .is-invalid {
      border-color: #dc3545 !important;
      background-color: #fff5f5 !important;
    }

    .is-invalid:focus {
      border-color: #dc3545 !important;
      box-shadow: 0 0 0 3px rgba(220, 53, 69, 0.1) !important;
    }

    .invalid-feedback {
      color: #dc3545;
      font-size: 0.875rem;
      margin-top: 5px;
      display: block;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
      .profile-hero {
        padding: 40px 0 30px 0;
      }

      .profile-hero h1 {
        font-size: 2rem;
      }

      .profile-container {
        padding: 30px 20px;
        margin: 20px;
        border-radius: 15px;
      }

      .section-header h2 {
        font-size: 1.5rem;
      }

      .btn-group {
        flex-direction: column;
      }

      .btn {
        width: 100%;
        justify-content: center;
      }

      .modal-dialog {
        margin: 20px;
      }

      .modal-body {
        padding: 20px;
      }

      .modal-footer {
        padding: 15px 20px;
      }
    }

    @media (max-width: 480px) {
      .profile-hero h1 {
        font-size: 1.8rem;
      }

      .profile-container {
        padding: 25px 15px;
        margin: 15px;
      }

      .section-header {
        flex-direction: column;
        text-align: center;
        gap: 15px;
      }

      .section-header i {
        margin-right: 0;
      }

      .form-control {
        padding: 12px 15px;
        font-size: 0.95rem;
      }

      .btn {
        padding: 12px 20px;
        font-size: 0.95rem;
      }
    }

    /* Animation */
    .profile-container {
      animation: fadeInUp 0.6s ease-out;
    }

    @keyframes fadeInUp {
      from {
        opacity: 0;
        transform: translateY(30px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    /* Loading states */
    .loading {
      opacity: 0.6;
      pointer-events: none;
    }

    .spinner {
      display: inline-block;
      width: 20px;
      height: 20px;
      border: 2px solid #f3f3f3;
      border-top: 2px solid #1a1a1a;
      border-radius: 50%;
      animation: spin 1s linear infinite;
    }

    @keyframes spin {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }
  </style>
</head>

<body>
  <!-- Profile Hero Section -->


  <div class="container">
    <div class="profile-container">
      <!-- Profile Information Section -->
      <div class="section-header">
        <i class="fas fa-user"></i>
        <h2>Informasi Pribadi</h2>
      </div>

      <form action="../proses/proses_update_profile.php" method="POST" id="profileForm">
        <div class="row">
          <div class="col-md-6">
            <div class="form-group">
              <label><i class="fas fa-user me-2"></i>Nama Lengkap</label>
              <input type="text" name="nama" value="<?= htmlspecialchars($user['nama'] ?? '') ?>" class="form-control" required placeholder="Masukkan nama lengkap">
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group">
              <label><i class="fas fa-envelope me-2"></i>Email</label>
              <input type="email" name="email" value="<?= htmlspecialchars($user['email'] ?? '') ?>" class="form-control" required placeholder="Masukkan email">
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group">
              <label><i class="fas fa-venus-mars me-2"></i>Jenis Kelamin</label>
              <select name="jenis_kelamin" class="form-control" required>
                <option value="">Pilih Jenis Kelamin</option>
                <option value="L" <?= ($user['jenis_kelamin'] ?? '') == 'L' ? 'selected' : '' ?>>Laki-laki</option>
                <option value="P" <?= ($user['jenis_kelamin'] ?? '') == 'P' ? 'selected' : '' ?>>Perempuan</option>
              </select>
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group">
              <label><i class="fas fa-phone me-2"></i>No Telepon</label>
              <input type="text" name="no_telp" value="<?= htmlspecialchars($user['no_telp'] ?? '') ?>" class="form-control" placeholder="Masukkan nomor telepon">
            </div>
          </div>
        </div>

        <!-- Address Section -->
        <div class="section-header" style="margin-top: 50px;">
          <i class="fas fa-map-marker-alt"></i>
          <h2>Alamat Pengiriman</h2>
        </div>

        <div class="row">
          <div class="col-md-6">
            <div class="form-group">
              <label><i class="fas fa-map me-2"></i>Provinsi</label>
              <select name="provinsi" id="provinsi" class="form-control" required>
                <option value="">Loading...</option>
              </select>
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group">
              <label><i class="fas fa-city me-2"></i>Kabupaten/Kota</label>
              <select name="kabupaten" id="kabupaten" class="form-control" required>
                <option value="">Pilih Provinsi dulu</option>
              </select>
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group">
              <label><i class="fas fa-building me-2"></i>Kecamatan</label>
              <select name="kecamatan" id="kecamatan" class="form-control" required>
                <option value="">Pilih Kabupaten dulu</option>
              </select>
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group">
              <label><i class="fas fa-home me-2"></i>Kelurahan</label>
              <select name="kelurahan" id="kelurahan" class="form-control" required>
                <option value="">Pilih Kecamatan dulu</option>
              </select>
            </div>
          </div>
          <div class="col-12">
            <div class="form-group">
              <label><i class="fas fa-map-pin me-2"></i>Alamat Lengkap</label>
              <textarea name="alamat_lengkap" class="form-control" rows="4" placeholder="Contoh: Jl. Sudirman No. 123, RT 01/RW 05, Kelurahan Menteng, Kecamatan Menteng, Jakarta Pusat"><?= htmlspecialchars($user['alamat_lengkap'] ?? '') ?></textarea>
            </div>
          </div>
        </div>

        <div class="btn-group">
          <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i>
            Simpan Perubahan
          </button>
          <button type="button" class="btn btn-outline" data-bs-toggle="modal" data-bs-target="#modalUbahPassword">
            <i class="fas fa-key"></i>
            Ubah Password
          </button>
        </div>
      </form>
    </div>
  </div>

  <!-- Password Change Modal -->
  <div class="modal fade" id="modalUbahPassword" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <form method="POST" action="../proses/proses_ubah_password.php" class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">
            <i class="fas fa-key me-2"></i>
            Ubah Password
          </h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <div class="form-group">
            <label><i class="fas fa-lock me-2"></i>Password Lama</label>
            <input type="password" name="password_lama" class="form-control" required placeholder="Masukkan password lama">
          </div>
          <div class="form-group">
            <label><i class="fas fa-lock me-2"></i>Password Baru</label>
            <input type="password" name="password_baru" class="form-control" required placeholder="Masukkan password baru">
          </div>
          <div class="form-group">
            <label><i class="fas fa-lock me-2"></i>Konfirmasi Password Baru</label>
            <input type="password" name="konfirmasi_password_baru" class="form-control" required placeholder="Konfirmasi password baru">
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i>
            Simpan
          </button>
          <button type="button" class="btn btn-outline" data-bs-dismiss="modal">
            <i class="fas fa-times"></i>
            Batal
          </button>
        </div>
      </form>
    </div>
  </div>

  <?php include '../footer.php'; ?>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

  <script>
    $(document).ready(function() {
      const currentProvinsi = "<?= htmlspecialchars($user['provinsi'] ?? '') ?>";
      const currentKabupaten = "<?= htmlspecialchars($user['kabupaten_kota'] ?? '') ?>";
      const currentKecamatan = "<?= htmlspecialchars($user['kecamatan'] ?? '') ?>";
      const currentKelurahan = "<?= htmlspecialchars($user['kelurahan'] ?? '') ?>";

      // Load provinces on page load
      loadProvinces();

      function loadProvinces() {
        $.ajax({
          url: 'https://www.emsifa.com/api-wilayah-indonesia/api/provinces.json',
          type: 'GET',
          success: function(data) {
            let options = '<option value="">Pilih Provinsi</option>';
            data.forEach(function(provinsi) {
              const selected = currentProvinsi === provinsi.name ? 'selected' : '';
              options += `<option value="${provinsi.name}" data-id="${provinsi.id}" ${selected}>${provinsi.name}</option>`;
            });
            $('#provinsi').html(options);

            // If there's a current province, load its kabupaten
            if (currentProvinsi) {
              const selectedOption = $('#provinsi option:selected');
              if (selectedOption.length > 0) {
                loadKabupaten(selectedOption.data('id'));
              }
            }
          },
          error: function() {
            $('#provinsi').html('<option value="">Error loading provinsi</option>');
          }
        });
      }

      function loadKabupaten(provinceId) {
        $.ajax({
          url: `https://www.emsifa.com/api-wilayah-indonesia/api/regencies/${provinceId}.json`,
          type: 'GET',
          success: function(data) {
            let options = '<option value="">Pilih Kabupaten/Kota</option>';
            data.forEach(function(kabupaten) {
              const selected = currentKabupaten === kabupaten.name ? 'selected' : '';
              options += `<option value="${kabupaten.name}" data-id="${kabupaten.id}" ${selected}>${kabupaten.name}</option>`;
            });
            $('#kabupaten').html(options);

            // If there's a current kabupaten, load its kecamatan
            if (currentKabupaten) {
              const selectedOption = $('#kabupaten option:selected');
              if (selectedOption.length > 0) {
                loadKecamatan(selectedOption.data('id'));
              }
            }
          },
          error: function() {
            $('#kabupaten').html('<option value="">Error loading kabupaten</option>');
          }
        });
      }

      function loadKecamatan(regencyId) {
        $.ajax({
          url: `https://www.emsifa.com/api-wilayah-indonesia/api/districts/${regencyId}.json`,
          type: 'GET',
          success: function(data) {
            let options = '<option value="">Pilih Kecamatan</option>';
            data.forEach(function(kecamatan) {
              const selected = currentKecamatan === kecamatan.name ? 'selected' : '';
              options += `<option value="${kecamatan.name}" data-id="${kecamatan.id}" ${selected}>${kecamatan.name}</option>`;
            });
            $('#kecamatan').html(options);

            // If there's a current kecamatan, load its kelurahan
            if (currentKecamatan) {
              const selectedOption = $('#kecamatan option:selected');
              if (selectedOption.length > 0) {
                loadKelurahan(selectedOption.data('id'));
              }
            }
          },
          error: function() {
            $('#kecamatan').html('<option value="">Error loading kecamatan</option>');
          }
        });
      }

      function loadKelurahan(districtId) {
        $.ajax({
          url: `https://www.emsifa.com/api-wilayah-indonesia/api/villages/${districtId}.json`,
          type: 'GET',
          success: function(data) {
            let options = '<option value="">Pilih Kelurahan</option>';
            data.forEach(function(kelurahan) {
              const selected = currentKelurahan === kelurahan.name ? 'selected' : '';
              options += `<option value="${kelurahan.name}" data-id="${kelurahan.id}" ${selected}>${kelurahan.name}</option>`;
            });
            $('#kelurahan').html(options);
          },
          error: function() {
            $('#kelurahan').html('<option value="">Error loading kelurahan</option>');
          }
        });
      }

      // Event handlers for cascading dropdowns
      $('#provinsi').change(function() {
        const selectedOption = $(this).find('option:selected');
        const provinceId = selectedOption.data('id');

        // Reset dependent dropdowns
        $('#kabupaten').html('<option value="">Pilih Kabupaten/Kota</option>');
        $('#kecamatan').html('<option value="">Pilih Kecamatan</option>');
        $('#kelurahan').html('<option value="">Pilih Kelurahan</option>');

        if (provinceId) {
          loadKabupaten(provinceId);
        }
      });

      $('#kabupaten').change(function() {
        const selectedOption = $(this).find('option:selected');
        const regencyId = selectedOption.data('id');

        // Reset dependent dropdowns
        $('#kecamatan').html('<option value="">Pilih Kecamatan</option>');
        $('#kelurahan').html('<option value="">Pilih Kelurahan</option>');

        if (regencyId) {
          loadKecamatan(regencyId);
        }
      });

      $('#kecamatan').change(function() {
        const selectedOption = $(this).find('option:selected');
        const districtId = selectedOption.data('id');

        // Reset dependent dropdown
        $('#kelurahan').html('<option value="">Pilih Kelurahan</option>');

        if (districtId) {
          loadKelurahan(districtId);
        }
      });

      // Form validation with specific field names
      $('#profileForm').submit(function(e) {
        const requiredFields = [{
            name: 'nama',
            label: 'Nama Lengkap'
          },
          {
            name: 'email',
            label: 'Email'
          },
          {
            name: 'jenis_kelamin',
            label: 'Jenis Kelamin'  
          },
          {
            name: 'provinsi',
            label: 'Provinsi'
          },
          {
            name: 'kabupaten',
            label: 'Kabupaten/Kota'
          },
          {
            name: 'kecamatan',
            label: 'Kecamatan'
          },
          {
            name: 'kelurahan',
            label: 'Kelurahan'
          }
        ];

        let isValid = true;
        let missingFields = [];

        requiredFields.forEach(function(field) {
          const value = $(`[name="${field.name}"]`).val();
          if (!value || value.trim() === '') {
            isValid = false;
            missingFields.push(field.label);
            $(`[name="${field.name}"]`).addClass('is-invalid');
          } else {
            $(`[name="${field.name}"]`).removeClass('is-invalid');
          }
        });

        if (!isValid) {
          e.preventDefault();
          alert('Field berikut harus diisi: ' + missingFields.join(', '));
        }
      });

      // Remove invalid class on input change
      $('input, select, textarea').on('change input', function() {
        $(this).removeClass('is-invalid');
      });
    });
  </script>
</body>

</html>