<?php
require '../config.php';
session_start();
require 'navbar.php'; // Ensure this path is correct

if (!isset($_SESSION['user_id'])) {
  header("Location: login.php");
  exit;
}

$user_id = $_SESSION['user_id'];

// Use prepared statements for security
$stmt = $conn->prepare("
     SELECT 
        k.*, 
        p.nama, 
        p.harga, 
        p.gambar,
        up.ukuran,
        up.stok AS stok_ukuran
    FROM keranjang k 
    JOIN produk p ON k.produk_id = p.id 
    JOIN ukuran_produk up ON k.ukuran_id = up.id
    WHERE k.pengguna_id = ?
");
if ($stmt === false) {
  die("Prepare failed: " . $conn->error);
}
$stmt->bind_param("i", $user_id);
$stmt->execute();
$query_result = $stmt->get_result();

$total = 0;
?>

<!DOCTYPE html>
<html lang="id">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Keranjang Belanja - vedge</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
  <style>
    body {
      background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
      color: #1a1a1a;
      font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
      line-height: 1.6;
    }

    .cart-hero {
      background: white;
      padding: 40px 0;
      margin-bottom: 40px;
      border-bottom: 1px solid #e9ecef;
    }

    .cart-hero h1 {
      font-family: 'Playfair Display', serif;
      font-size: 2.5rem;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 10px;
      text-align: center;
    }

    .cart-hero p {
      color: #666;
      font-size: 1.1rem;
      text-align: center;
      margin: 0;
    }

    .cart-container {
      background: white;
      border-radius: 20px;
      box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
      overflow: hidden;
      margin-bottom: 40px;
    }

    .cart-header {
      background: #f8f9fa;
      padding: 25px 30px;
      border-bottom: 1px solid #e9ecef;
    }

    .cart-title {
      font-family: 'Playfair Display', serif;
      font-size: 1.8rem;
      font-weight: 600;
      color: #1a1a1a;
      margin: 0;
      display: flex;
      align-items: center;
      gap: 12px;
    }

    .cart-count {
      background: #1a1a1a;
      color: white;
      padding: 4px 12px;
      border-radius: 20px;
      font-size: 0.9rem;
      font-weight: 600;
    }

    .cart-table {
      margin: 0;
    }

    .cart-table thead th {
      background: #f8f9fa;
      color: #1a1a1a;
      font-weight: 600;
      padding: 20px;
      border: none;
      font-size: 0.9rem;
      text-transform: uppercase;
      letter-spacing: 0.5px;
    }

    .cart-table tbody tr {
      border-bottom: 1px solid #f0f0f0;
      transition: all 0.3s ease;
    }

    .cart-table tbody tr:hover {
      background: #f8f9fa;
    }

    .cart-table td {
      padding: 20px;
      vertical-align: middle;
      border: none;
    }

    .product-info {
      display: flex;
      align-items: center;
      gap: 15px;
    }

    .product-image {
      width: 80px;
      height: 80px;
      object-fit: cover;
      border-radius: 12px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    }

    .product-details h6 {
      font-weight: 600;
      color: #1a1a1a;
      margin-bottom: 5px;
      font-size: 1.1rem;
    }

    .product-details p {
      color: #666;
      margin: 0;
      font-size: 0.9rem;
    }

    .price-text {
      font-weight: 600;
      color: #1a1a1a;
      font-size: 1.1rem;
    }

    .quantity-badge {
      background: #f8f9fa;
      color: #1a1a1a;
      padding: 8px 16px;
      border-radius: 20px;
      font-weight: 600;
      display: inline-block;
    }

    .size-badge {
      background: #1a1a1a;
      color: white;
      padding: 6px 12px;
      border-radius: 15px;
      font-size: 0.85rem;
      font-weight: 600;
    }

    .subtotal-text {
      font-weight: 700;
      color: #1a1a1a;
      font-size: 1.2rem;
    }

    .remove-btn {
      background: #dc3545;
      color: white;
      border: none;
      padding: 8px 16px;
      border-radius: 8px;
      font-size: 0.85rem;
      font-weight: 600;
      transition: all 0.3s ease;
      text-decoration: none;
      display: inline-flex;
      align-items: center;
      gap: 6px;
    }

    .remove-btn:hover {
      background: #c82333;
      color: white;
      transform: translateY(-1px);
      box-shadow: 0 4px 12px rgba(220, 53, 69, 0.3);
    }

    .stock-warning {
      background: #fff3cd;
      border: 1px solid #ffeaa7;
      color: #856404;
      padding: 8px 12px;
      border-radius: 8px;
      font-size: 0.8rem;
      margin-top: 8px;
      display: flex;
      align-items: center;
      gap: 6px;
    }

    .cart-total-section {
      background: #f8f9fa;
      padding: 30px;
      border-top: 1px solid #e9ecef;
    }

    .total-row {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 15px 0;
      border-bottom: 1px solid #e9ecef;
    }

    .total-row:last-child {
      border-bottom: none;
      font-size: 1.3rem;
      font-weight: 700;
      color: #1a1a1a;
    }

    .cart-actions {
      display: flex;
      gap: 15px;
      margin-top: 30px;
    }

    .btn {
      padding: 15px 30px;
      border-radius: 12px;
      font-weight: 600;
      transition: all 0.3s ease;
      display: inline-flex;
      align-items: center;
      gap: 8px;
      text-decoration: none;
      border: 2px solid transparent;
    }

    .btn-primary {
      background: linear-gradient(135deg, #1a1a1a 0%, #333 100%);
      color: white;
      border-color: #1a1a1a;
    }

    .btn-primary:hover {
      background: linear-gradient(135deg, #333 0%, #1a1a1a 100%);
      color: white;
      transform: translateY(-2px);
      box-shadow: 0 8px 25px rgba(26, 26, 26, 0.2);
    }

    .btn-outline {
      background: transparent;
      color: #1a1a1a;
      border-color: #1a1a1a;
    }

    .btn-outline:hover {
      background: #1a1a1a;
      color: white;
      transform: translateY(-2px);
      box-shadow: 0 8px 25px rgba(26, 26, 26, 0.2);
    }

    .btn:disabled {
      opacity: 0.6;
      cursor: not-allowed;
      transform: none;
      box-shadow: none;
    }

    .empty-cart {
      text-align: center;
      padding: 60px 30px;
    }

    .empty-cart-icon {
      font-size: 4rem;
      color: #ccc;
      margin-bottom: 20px;
    }

    .empty-cart h3 {
      font-family: 'Playfair Display', serif;
      font-size: 1.8rem;
      color: #1a1a1a;
      margin-bottom: 15px;
    }

    .empty-cart p {
      color: #666;
      font-size: 1.1rem;
      margin-bottom: 30px;
    }

    .empty-cart .btn {
      margin: 0 auto;
    }

    /* Mobile Card Design */
    .cart-item-card {
      background: white;
      border: 1px solid #e9ecef;
      border-radius: 15px;
      padding: 20px;
      margin-bottom: 20px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
      transition: all 0.3s ease;
    }

    .cart-item-card:hover {
      transform: translateY(-2px);
      box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
    }

    .cart-item-card.warning {
      border-left: 4px solid #ffc107;
      background: rgba(255, 243, 205, 0.3);
    }

    .cart-item-header {
      display: flex;
      gap: 15px;
      margin-bottom: 20px;
    }

    .cart-item-image {
      width: 70px;
      height: 70px;
      object-fit: cover;
      border-radius: 10px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    }

    .cart-item-details {
      flex: 1;
    }

    .cart-item-name {
      font-weight: 600;
      color: #1a1a1a;
      font-size: 1.1rem;
      margin-bottom: 5px;
    }

    .cart-item-info {
      display: grid;
      grid-template-columns: 1fr 1fr;
      gap: 15px;
      margin-bottom: 20px;
    }

    .info-item {
      background: #f8f9fa;
      padding: 12px;
      border-radius: 10px;
      text-align: center;
    }

    .info-label {
      font-size: 0.8rem;
      color: #666;
      text-transform: uppercase;
      letter-spacing: 0.5px;
      margin-bottom: 5px;
    }

    .info-value {
      font-weight: 600;
      color: #1a1a1a;
      font-size: 1rem;
    }

    .cart-item-total {
      background: #1a1a1a;
      color: white;
      padding: 15px;
      border-radius: 10px;
      text-align: center;
      margin-bottom: 15px;
    }

    .total-label {
      font-size: 0.8rem;
      opacity: 0.8;
      text-transform: uppercase;
      letter-spacing: 0.5px;
    }

    .total-value {
      font-size: 1.2rem;
      font-weight: 700;
      margin-top: 5px;
    }

    .cart-item-actions {
      text-align: center;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
      .cart-hero h1 {
        font-size: 2rem;
      }

      .cart-container {
        margin: 20px;
        border-radius: 15px;
      }

      .cart-header {
        padding: 20px;
      }

      .cart-title {
        font-size: 1.5rem;
      }

      .cart-table {
        display: none;
      }

      .mobile-cards {
        display: block;
        padding: 20px;
      }

      .cart-actions {
        flex-direction: column;
        padding: 0 20px 20px;
      }

      .btn {
        width: 100%;
        justify-content: center;
      }

      .main-content {
        padding-bottom: 120px;
      }
    }

    @media (max-width: 480px) {
      .cart-hero h1 {
        font-size: 1.8rem;
      }

      .cart-container {
        margin: 15px;
      }

      .cart-item-header {
        gap: 12px;
      }

      .cart-item-image {
        width: 60px;
        height: 60px;
      }

      .cart-item-info {
        grid-template-columns: 1fr;
        gap: 10px;
      }

      .info-value {
        font-size: 0.9rem;
      }
    }

    /* Animation */
    .cart-container {
      animation: fadeInUp 0.6s ease-out;
    }

    @keyframes fadeInUp {
      from {
        opacity: 0;
        transform: translateY(30px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    /* Hide desktop table on mobile */
    @media (max-width: 768px) {
      .desktop-table {
        display: none;
      }
    }

    @media (min-width: 769px) {
      .mobile-cards {
        display: none;
      }
    }
  </style>
</head>

<body>
  <!-- Cart Hero Section -->
  <section class="cart-hero">
    <div class="container">
      <h1>Keranjang Belanja</h1>
      <p>Kelola produk yang ingin Anda beli</p>
    </div>
  </section>

  <div class="container">
    <?php if ($query_result->num_rows > 0): ?>
      <div class="cart-container">
        <div class="cart-header">
          <h2 class="cart-title">
            <i class="fas fa-shopping-cart"></i>
            Keranjang Belanja
            <span class="cart-count"><?= $query_result->num_rows ?> item</span>
          </h2>
        </div>

        <form action="checkout.php" method="POST">
          <!-- Desktop Table View -->
          <div class="desktop-table">
            <table class="cart-table">
              <thead>
                <tr>
                  <th>Produk</th>
                  <th>Harga</th>
                  <th>Jumlah</th>
                  <th>Ukuran</th>
                  <th>Subtotal</th>
                  <th>Aksi</th>
                </tr>
              </thead>
              <tbody>
                <?php
                $total_stok_issues = 0;
                $query_result->data_seek(0);
                while ($row = $query_result->fetch_assoc()) :
                  $subtotal = $row['harga'] * $row['jumlah'];
                  $total += $subtotal;

                  // Cek apakah ada masalah stok
                  $stok_issue = false;
                  if ($row['stok_ukuran'] <= 0) {
                    $stok_issue = true;
                    $total_stok_issues++;
                  } elseif ($row['jumlah'] > $row['stok_ukuran']) {
                    $stok_issue = true;
                    $total_stok_issues++;
                  }
                ?>
                  <tr class="<?= $stok_issue ? 'table-warning' : '' ?>">
                    <td>
                      <div class="product-info">
                        <img src="../upload/<?= htmlspecialchars($row['gambar']) ?>" alt="<?= htmlspecialchars($row['nama']) ?>" class="product-image">
                        <div class="product-details">
                          <h6><?= htmlspecialchars($row['nama']) ?></h6>
                          <?php if ($stok_issue): ?>
                            <div class="stock-warning">
                              <i class="fas fa-exclamation-triangle"></i>
                              <?= $row['stok_ukuran'] <= 0 ? 'Stok Habis' : 'Jumlah melebihi stok tersedia (' . $row['stok_ukuran'] . ')' ?>
                            </div>
                          <?php endif; ?>
                        </div>
                      </div>
                    </td>
                    <td>
                      <span class="price-text">Rp<?= number_format($row['harga'], 0, ',', '.') ?></span>
                    </td>
                    <td>
                      <span class="quantity-badge"><?= htmlspecialchars($row['jumlah']) ?></span>
                      <?php if ($stok_issue && $row['stok_ukuran'] > 0): ?>
                        <br><small class="text-muted">Stok: <?= $row['stok_ukuran'] ?></small>
                      <?php endif; ?>
                    </td>
                    <td>
                      <span class="size-badge"><?= htmlspecialchars($row['ukuran']) ?></span>
                      <?php if ($row['stok_ukuran'] <= 0): ?>
                        <br><small class="text-danger">Tidak Tersedia</small>
                      <?php endif; ?>
                    </td>
                    <td>
                      <span class="subtotal-text">Rp<?= number_format($subtotal, 0, ',', '.') ?></span>
                    </td>
                    <td>
                      <a href="hapus_keranjang.php?id=<?= htmlspecialchars($row['id']) ?>" class="remove-btn" onclick="return confirm('Apakah Anda yakin ingin menghapus produk ini dari keranjang?')">
                        <i class="fas fa-trash"></i>
                        Hapus
                      </a>
                    </td>
                  </tr>
                <?php endwhile; ?>
              </tbody>
            </table>
          </div>

          <!-- Mobile Card View -->
          <div class="mobile-cards">
            <?php
            $total = 0;
            $total_stok_issues = 0;
            $query_result->data_seek(0);
            while ($row = $query_result->fetch_assoc()) :
              $subtotal = $row['harga'] * $row['jumlah'];
              $total += $subtotal;

              $stok_issue = false;
              if ($row['stok_ukuran'] <= 0) {
                $stok_issue = true;
                $total_stok_issues++;
              } elseif ($row['jumlah'] > $row['stok_ukuran']) {
                $stok_issue = true;
                $total_stok_issues++;
              }
            ?>
              <div class="cart-item-card <?= $stok_issue ? 'warning' : '' ?>">
                <div class="cart-item-header">
                  <img src="../upload/<?= htmlspecialchars($row['gambar']) ?>" alt="<?= htmlspecialchars($row['nama']) ?>" class="cart-item-image">
                  <div class="cart-item-details">
                    <div class="cart-item-name"><?= htmlspecialchars($row['nama']) ?></div>
                    <?php if ($stok_issue): ?>
                      <div class="stock-warning">
                        <i class="fas fa-exclamation-triangle"></i>
                        <?= $row['stok_ukuran'] <= 0 ? 'Stok Habis' : 'Jumlah melebihi stok tersedia (' . $row['stok_ukuran'] . ')' ?>
                      </div>
                    <?php endif; ?>
                  </div>
                </div>

                <div class="cart-item-info">
                  <div class="info-item">
                    <div class="info-label">Harga</div>
                    <div class="info-value">Rp<?= number_format($row['harga'], 0, ',', '.') ?></div>
                  </div>
                  <div class="info-item">
                    <div class="info-label">Jumlah</div>
                    <div class="info-value">
                      <?= htmlspecialchars($row['jumlah']) ?>
                      <?php if ($stok_issue && $row['stok_ukuran'] > 0): ?>
                        <br><small class="text-muted">Stok: <?= $row['stok_ukuran'] ?></small>
                      <?php endif; ?>
                    </div>
                  </div>
                  <div class="info-item">
                    <div class="info-label">Ukuran</div>
                    <div class="info-value">
                      <?= htmlspecialchars($row['ukuran']) ?>
                      <?php if ($row['stok_ukuran'] <= 0): ?>
                        <br><small class="text-danger">Tidak Tersedia</small>
                      <?php endif; ?>
                    </div>
                  </div>
                </div>

                <div class="cart-item-total">
                  <div class="total-label">Subtotal</div>
                  <div class="total-value">Rp<?= number_format($subtotal, 0, ',', '.') ?></div>
                </div>

                <div class="cart-item-actions">
                  <a href="hapus_keranjang.php?id=<?= htmlspecialchars($row['id']) ?>" class="remove-btn" onclick="return confirm('Apakah Anda yakin ingin menghapus produk ini dari keranjang?')">
                    <i class="fas fa-trash"></i>
                    Hapus dari Keranjang
                  </a>
                </div>
              </div>
            <?php endwhile; ?>
          </div>

          <?php if ($total_stok_issues > 0): ?>
            <div class="alert alert-warning m-3">
              <i class="fas fa-exclamation-triangle me-2"></i>
              <strong>Perhatian!</strong> Ada <?= $total_stok_issues ?> produk dengan masalah stok.
              Silakan hapus produk yang tidak tersedia atau sesuaikan jumlah sebelum melanjutkan checkout.
            </div>
          <?php endif; ?>

          <div class="cart-total-section">
            <div class="total-row">
              <span>Total Belanja</span>
              <span class="subtotal-text">Rp<?= number_format($total, 0, ',', '.') ?></span>
            </div>
          </div>

          <div class="cart-actions">
            <a href="../index.php" class="btn btn-outline">
              <i class="fas fa-arrow-left"></i>
              Belanja Lagi
            </a>
            <button type="submit" class="btn btn-primary" <?= $total_stok_issues > 0 ? 'disabled title="Tidak bisa checkout - ada masalah stok"' : '' ?>>
              <i class="fas fa-credit-card"></i>
              Checkout
            </button>
          </div>
        </form>
      </div>
    <?php else: ?>
      <div class="cart-container">
        <div class="empty-cart">
          <div class="empty-cart-icon">
            <i class="fas fa-shopping-cart"></i>
          </div>
          <h3>Keranjang Belanja Kosong</h3>
          <p>Belum ada produk di keranjang belanja Anda.</p>
          <a href="../index.php" class="btn btn-primary">
            <i class="fas fa-shopping-bag"></i>
            Mulai Berbelanja
          </a>
        </div>
      </div>
    <?php endif; ?>
  </div>

  <?php include '../footer.php'; ?>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>