<?php
require '../config.php';
session_start();
require '../pelanggan/navbar.php';

if (!isset($_SESSION['user_id'])) {
  header("Location: login.php");
  exit;
}

$user_id = $_SESSION['user_id'];
$pengguna = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM pengguna WHERE id = $user_id"));
$keranjang = mysqli_query($conn, "
      SELECT 
        k.*, 
        p.nama, 
        p.harga, 
        p.gambar,
        up.ukuran,
        up.stok AS stok_ukuran
    FROM keranjang k 
    JOIN produk p ON k.produk_id = p.id 
    JOIN ukuran_produk up ON k.ukuran_id = up.id
    WHERE k.pengguna_id = $user_id
");

$total_harga = 0;
$keranjang_data = [];
$ongkir = 20000;

while ($item = mysqli_fetch_assoc($keranjang)) {
  $subtotal = $item['harga'] * $item['jumlah'];
  $total_harga += $subtotal;
  $keranjang_data[] = $item + ['subtotal' => $subtotal];
}
?>

<!DOCTYPE html>
<html lang="id">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Checkout - vedge</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
  <style>
    body {
      background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
      color: #1a1a1a;
      font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
      line-height: 1.6;
    }

    .checkout-hero {
      background: white;
      padding: 40px 0;
      margin-bottom: 40px;
      border-bottom: 1px solid #e9ecef;
    }

    .checkout-hero h1 {
      font-family: 'Playfair Display', serif;
      font-size: 2.5rem;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 10px;
      text-align: center;
    }

    .checkout-hero p {
      color: #666;
      font-size: 1.1rem;
      text-align: center;
      margin: 0;
    }

    .checkout-container {
      background: white;
      border-radius: 20px;
      box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
      overflow: hidden;
      margin-bottom: 40px;
    }

    .section-header {
      background: #f8f9fa;
      padding: 25px 30px;
      border-bottom: 1px solid #e9ecef;
    }

    .section-title {
      font-family: 'Playfair Display', serif;
      font-size: 1.5rem;
      font-weight: 600;
      color: #1a1a1a;
      margin: 0;
      display: flex;
      align-items: center;
      gap: 12px;
    }

    .products-section {
      padding: 30px;
    }

    .product-item {
      display: flex;
      align-items: center;
      gap: 20px;
      padding: 20px;
      border: 1px solid #f0f0f0;
      border-radius: 12px;
      margin-bottom: 15px;
      background: #fafafa;
      transition: all 0.3s ease;
    }

    .product-item:hover {
      transform: translateY(-2px);
      box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
    }

    .product-image {
      width: 80px;
      height: 80px;
      object-fit: cover;
      border-radius: 10px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    }

    .product-details {
      flex: 1;
    }

    .product-name {
      font-weight: 600;
      color: #1a1a1a;
      font-size: 1.1rem;
      margin-bottom: 5px;
    }

    .product-info {
      display: flex;
      gap: 20px;
      color: #666;
      font-size: 0.9rem;
    }

    .product-price {
      font-weight: 700;
      color: #1a1a1a;
      font-size: 1.1rem;
    }

    .summary-section {
      background: #f8f9fa;
      padding: 30px;
      border-radius: 15px;
      margin: 30px;
    }

    .summary-row {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 12px 0;
      border-bottom: 1px solid #e9ecef;
    }

    .summary-row:last-child {
      border-bottom: none;
      font-size: 1.3rem;
      font-weight: 700;
      color: #1a1a1a;
      padding-top: 20px;
      border-top: 2px solid #e9ecef;
    }

    .summary-label {
      color: #666;
      font-weight: 500;
    }

    .summary-value {
      font-weight: 600;
      color: #1a1a1a;
    }

    .address-section {
      padding: 30px;
    }

    .address-card {
      background: #f8f9fa;
      border-radius: 15px;
      padding: 25px;
      border: 1px solid #e9ecef;
    }

    .form-group {
      margin-bottom: 20px;
    }

    .form-label {
      font-weight: 600;
      color: #1a1a1a;
      margin-bottom: 8px;
      font-size: 0.95rem;
      display: flex;
      align-items: center;
      gap: 8px;
    }

    .form-control {
      border: 2px solid #e9ecef;
      border-radius: 12px;
      padding: 15px;
      font-size: 1rem;
      transition: all 0.3s ease;
      background: white;
      color: #1a1a1a;
    }

    .form-control:focus {
      border-color: #1a1a1a;
      box-shadow: 0 0 0 3px rgba(26, 26, 26, 0.1);
      outline: none;
    }

    .form-control[readonly] {
      background: #f8f9fa;
      color: #666;
    }

    .payment-section {
      padding: 30px;
    }

    .payment-methods {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
      gap: 15px;
      margin-bottom: 30px;
    }

    .payment-method {
      background: white;
      border: 2px solid #e9ecef;
      border-radius: 15px;
      padding: 20px;
      text-align: center;
      cursor: pointer;
      transition: all 0.3s ease;
      position: relative;
      overflow: hidden;
    }

    .payment-method:hover {
      border-color: #1a1a1a;
      transform: translateY(-2px);
      box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
    }

    .payment-method.selected {
      border-color: #1a1a1a;
      background: #f8f9fa;
      box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
    }

    .payment-method img {
      width: 60px;
      height: 40px;
      object-fit: contain;
      margin-bottom: 10px;
      filter: grayscale(50%);
      transition: filter 0.3s ease;
    }

    .payment-method:hover img,
    .payment-method.selected img {
      filter: grayscale(0%);
    }

    .payment-method-name {
      font-weight: 600;
      color: #1a1a1a;
      font-size: 0.9rem;
    }

    .payment-info {
      background: #f8f9fa;
      border-radius: 15px;
      padding: 20px;
      border: 1px solid #e9ecef;
      margin-top: 20px;
      display: none;
    }

    .payment-info.show {
      display: block;
      animation: fadeInUp 0.3s ease-out;
    }

    .account-number {
      background: white;
      border: 2px solid #e9ecef;
      border-radius: 10px;
      padding: 15px;
      font-weight: 600;
      color: #1a1a1a;
      text-align: center;
      margin-bottom: 15px;
    }

    .checkout-button {
      background: linear-gradient(135deg, #1a1a1a 0%, #333 100%);
      color: white;
      border: none;
      border-radius: 12px;
      padding: 20px 40px;
      font-size: 1.1rem;
      font-weight: 600;
      width: 100%;
      transition: all 0.3s ease;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 10px;
    }

    .checkout-button:hover {
      background: linear-gradient(135deg, #333 0%, #1a1a1a 100%);
      transform: translateY(-2px);
      box-shadow: 0 8px 25px rgba(26, 26, 26, 0.2);
      color: white;
    }

    .checkout-button:disabled {
      opacity: 0.6;
      cursor: not-allowed;
      transform: none;
      box-shadow: none;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
      .checkout-hero h1 {
        font-size: 2rem;
      }

      .checkout-container {
        margin: 20px;
        border-radius: 15px;
      }

      .section-header {
        padding: 20px;
      }

      .section-title {
        font-size: 1.3rem;
      }

      .products-section,
      .address-section,
      .payment-section {
        padding: 20px;
      }

      .product-item {
        flex-direction: column;
        text-align: center;
        gap: 15px;
      }

      .product-info {
        justify-content: center;
        flex-wrap: wrap;
      }

      .payment-methods {
        grid-template-columns: 1fr;
        gap: 10px;
      }

      .summary-section {
        margin: 20px;
        padding: 20px;
      }

      .main-content {
        padding-bottom: 120px;
      }
    }

    @media (max-width: 480px) {
      .checkout-hero h1 {
        font-size: 1.8rem;
      }

      .checkout-container {
        margin: 15px;
      }

      .product-image {
        width: 60px;
        height: 60px;
      }

      .product-name {
        font-size: 1rem;
      }

      .product-info {
        font-size: 0.8rem;
        gap: 10px;
      }

      .summary-section {
        margin: 15px;
        padding: 15px;
      }
    }

    /* Animation */
    .checkout-container {
      animation: fadeInUp 0.6s ease-out;
    }

    @keyframes fadeInUp {
      from {
        opacity: 0;
        transform: translateY(30px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }
  </style>
</head>

<body>
  <!-- Checkout Hero Section -->
  <section class="checkout-hero">
    <div class="container">
      <h1>Checkout Pesanan</h1>
      <p>Lengkapi informasi pembayaran untuk menyelesaikan pesanan Anda</p>
    </div>
  </section>

  <div class="container">
    <form action="../proses/proses_checkout.php" method="POST" enctype="multipart/form-data">
      <div class="checkout-container">
        <!-- Products Section -->
        <div class="section-header">
          <h2 class="section-title">
            <i class="fas fa-shopping-bag"></i>
            Detail Produk
          </h2>
        </div>
        <div class="products-section">
          <?php foreach ($keranjang_data as $item): ?>
            <div class="product-item">
              <img src="../upload/<?= htmlspecialchars($item['gambar']) ?>" alt="<?= htmlspecialchars($item['nama']) ?>" class="product-image">
              <div class="product-details">
                <div class="product-name"><?= htmlspecialchars($item['nama']) ?></div>
                <div class="product-info">
                  <span><i class="fas fa-ruler me-1"></i>Ukuran: <?= htmlspecialchars($item['ukuran']) ?></span>
                  <span><i class="fas fa-sort-numeric-up me-1"></i>Jumlah: <?= $item['jumlah'] ?></span>
                </div>
              </div>
              <div class="product-price">
                Rp<?= number_format($item['subtotal'], 0, ',', '.') ?>
              </div>
            </div>
          <?php endforeach; ?>
        </div>

        <!-- Order Summary -->
        <div class="summary-section">
          <h3 style="margin-bottom: 20px; font-family: 'Playfair Display', serif; color: #1a1a1a;">Ringkasan Pesanan</h3>
          <div class="summary-row">
            <span class="summary-label">Total Belanja</span>
            <span class="summary-value">Rp<?= number_format($total_harga, 0, ',', '.') ?></span>
          </div>
          <div class="summary-row">
            <span class="summary-label">Ongkos Kirim</span>
            <span class="summary-value">Rp<?= number_format($ongkir, 0, ',', '.') ?></span>
          </div>
          <div class="summary-row">
            <span class="summary-label">Total Pembayaran</span>
            <span class="summary-value">Rp<?= number_format($total_harga + $ongkir, 0, ',', '.') ?></span>
          </div>
        </div>

        <!-- Address Section -->
        <div class="section-header">
          <h2 class="section-title">
            <i class="fas fa-map-marker-alt"></i>
            Alamat Pengiriman
          </h2>
        </div>
        <div class="address-section">
          <div class="address-card">
            <div class="form-group">
              <label class="form-label">
                <i class="fas fa-user"></i>
                Nama Penerima
              </label>
              <input type="text" class="form-control" value="<?= htmlspecialchars($pengguna['nama']) ?>" readonly>
            </div>
            <div class="form-group">
              <label class="form-label">
                <i class="fas fa-phone"></i>
                No. Telepon
              </label>
              <input type="text" class="form-control" value="<?= htmlspecialchars($pengguna['no_telp']) ?>" readonly>
            </div>
            <div class="form-group">
              <label class="form-label">
                <i class="fas fa-home"></i>
                Alamat Lengkap
              </label>
              <textarea class="form-control" rows="3" readonly><?= htmlspecialchars($pengguna['alamat_lengkap']) ?>,
<?= $pengguna['kelurahan'] ?>, <?= $pengguna['kecamatan'] ?>, <?= $pengguna['kabupaten_kota'] ?>, <?= $pengguna['provinsi'] ?></textarea>
            </div>
            <div class="form-group">
              <label class="form-label">
                <i class="fas fa-shipping-fast"></i>
                Ongkos Kirim
              </label>
              <input type="text" class="form-control" value="Rp<?= number_format($ongkir, 0, ',', '.') ?>" readonly>
            </div>
            <div class="form-group">
              <label class="form-label">
                <i class="fas fa-percentage"></i>
                Kode Diskon (Opsional)
              </label>
              <input type="text" name="kode_diskon" class="form-control" placeholder="Masukkan kode diskon">
            </div>
          </div>
        </div>

        <!-- Payment Section -->
        <div class="section-header">
          <h2 class="section-title">
            <i class="fas fa-credit-card"></i>
            Metode Pembayaran
          </h2>
        </div>
        <div class="payment-section">
          <input type="hidden" name="metode_pembayaran" id="metode_pembayaran" required>
          <input type="hidden" name="total_harga" value="<?= $total_harga ?>">

          <div class="payment-methods">
            <div class="payment-method" data-metode="mandiri">
              <img src="../assets/mandiri.png" alt="Mandiri">
              <div class="payment-method-name">Bank Mandiri</div>
            </div>
            <div class="payment-method" data-metode="bca">
              <img src="../assets/bca.png" alt="BCA">
              <div class="payment-method-name">Bank BCA</div>
            </div>
            <div class="payment-method" data-metode="bri">
              <img src="../assets/bri.png" alt="BRI">
              <div class="payment-method-name">Bank BRI</div>
            </div>
            <div class="payment-method" data-metode="gopay">
              <img src="../assets/gopay.png" alt="GoPay">
              <div class="payment-method-name">GoPay</div>
            </div>
          </div>

          <div class="payment-info" id="payment_info">
            <h4 style="margin-bottom: 15px; color: #1a1a1a;">
              <i class="fas fa-info-circle me-2"></i>
              Informasi Pembayaran
            </h4>
            <div class="account-number" id="account_number"></div>
            <p style="color: #666; font-size: 0.9rem; margin: 0;">
              <i class="fas fa-exclamation-triangle me-2"></i>
              Silakan transfer sesuai total pembayaran ke nomor rekening di atas, lalu upload bukti pembayaran.
            </p>
          </div>

          <button type="submit" class="checkout-button" id="checkout_btn" disabled>
            <i class="fas fa-arrow-right"></i>
            Lanjutkan ke Pembayaran
          </button>
        </div>
      </div>
    </form>
  </div>

  <?php include '../footer.php'; ?>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

  <script>
    const rekeningInfo = {
      mandiri: '137-00-98763-1 a.n. Nando',
      bca: '7391516 a.n. Nando',
      bri: '4791-0105-81-536 a.n. Nando',
      gopay: '0813142158 a.n. Nando'
    };

    const paymentMethods = document.querySelectorAll('.payment-method');
    const paymentInfo = document.getElementById('payment_info');
    const accountNumber = document.getElementById('account_number');
    const metodeInput = document.getElementById('metode_pembayaran');
    const checkoutBtn = document.getElementById('checkout_btn');

    paymentMethods.forEach(method => {
      method.addEventListener('click', function() {
        // Remove previous selection
        paymentMethods.forEach(m => m.classList.remove('selected'));
        this.classList.add('selected');

        const metode = this.dataset.metode;
        metodeInput.value = metode;

        if (rekeningInfo[metode]) {
          paymentInfo.classList.add('show');
          accountNumber.textContent = rekeningInfo[metode];
          checkoutBtn.disabled = false;
        } else {
          paymentInfo.classList.remove('show');
          accountNumber.textContent = '';
          checkoutBtn.disabled = true;
        }
      });
    });
  </script>
</body>

</html>