<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Forgot Password - vedge</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Playfair Display', serif;
      background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
      min-height: 100vh;
      color: #1a1a1a;
      line-height: 1.6;
    }

    .forgot-container {
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 2rem 1rem;
    }

    .forgot-card {
      background: rgba(255, 255, 255, 0.95);
      backdrop-filter: blur(20px);
      border-radius: 24px;
      box-shadow: 0 20px 60px rgba(0, 0, 0, 0.1);
      border: 1px solid rgba(255, 255, 255, 0.2);
      max-width: 450px;
      width: 100%;
      overflow: hidden;
      transition: all 0.3s ease;
    }

    .forgot-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 30px 80px rgba(0, 0, 0, 0.15);
    }

    .brand-header {
      background: linear-gradient(135deg, #1a1a1a 0%, #333333 100%);
      color: white;
      padding: 2.5rem 2rem;
      text-align: center;
      position: relative;
      overflow: hidden;
    }

    .brand-header::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="white" opacity="0.1"/><circle cx="75" cy="75" r="1" fill="white" opacity="0.1"/><circle cx="50" cy="10" r="0.5" fill="white" opacity="0.1"/><circle cx="10" cy="60" r="0.5" fill="white" opacity="0.1"/><circle cx="90" cy="40" r="0.5" fill="white" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
      opacity: 0.3;
    }

    .brand-title {
      font-size: 2.5rem;
      font-weight: 800;
      margin-bottom: 0.5rem;
      position: relative;
      z-index: 1;
      letter-spacing: -0.02em;
    }

    .brand-subtitle {
      font-size: 1rem;
      font-weight: 400;
      opacity: 0.9;
      position: relative;
      z-index: 1;
      font-style: italic;
    }

    .forgot-body {
      padding: 2.5rem 2rem;
    }

    .welcome-text {
      text-align: center;
      margin-bottom: 2rem;
    }

    .welcome-title {
      font-size: 1.5rem;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 0.5rem;
    }

    .welcome-subtitle {
      color: #666;
      font-size: 0.95rem;
    }

    .icon-wrapper {
      background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
      border-radius: 50%;
      width: 80px;
      height: 80px;
      display: flex;
      align-items: center;
      justify-content: center;
      margin: 0 auto 1.5rem;
      border: 2px solid #e9ecef;
    }

    .icon-wrapper i {
      font-size: 2rem;
      color: #1a1a1a;
    }

    .alert {
      border-radius: 12px;
      padding: 1rem 1.5rem;
      margin-bottom: 1.5rem;
      border: none;
      font-weight: 500;
    }

    .alert-info {
      background: linear-gradient(135deg, #eff6ff 0%, #dbeafe 100%);
      color: #1d4ed8;
      border-left: 4px solid #1d4ed8;
    }

    .alert-danger {
      background: linear-gradient(135deg, #fee 0%, #fcc 100%);
      color: #c53030;
      border-left: 4px solid #c53030;
    }

    .form-group {
      margin-bottom: 1.5rem;
    }

    .form-label {
      font-weight: 600;
      color: #1a1a1a;
      margin-bottom: 0.75rem;
      font-size: 0.95rem;
      text-transform: uppercase;
      letter-spacing: 0.5px;
    }

    .input-wrapper {
      position: relative;
      display: flex;
      align-items: center;
      background: white;
      border: 2px solid #e9ecef;
      border-radius: 12px;
      transition: all 0.3s ease;
      overflow: hidden;
    }

    .input-wrapper:focus-within {
      border-color: #1a1a1a;
      box-shadow: 0 0 0 3px rgba(26, 26, 26, 0.1);
    }

    .input-icon {
      padding: 1rem;
      color: #666;
      font-size: 1.1rem;
      background: #f8f9fa;
      border-right: 1px solid #e9ecef;
    }

    .form-control {
      border: none;
      padding: 1rem 1.5rem;
      font-size: 1rem;
      background: transparent;
      color: #1a1a1a;
      font-family: 'Playfair Display', serif;
      flex: 1;
    }

    .form-control:focus {
      outline: none;
      box-shadow: none;
    }

    .form-control::placeholder {
      color: #999;
      font-style: italic;
    }

    .form-text {
      font-size: 0.85rem;
      color: #666;
      margin-top: 0.5rem;
      font-style: italic;
    }

    .form-text i {
      margin-right: 0.5rem;
      color: #1a1a1a;
    }

    .btn-reset {
      background: linear-gradient(135deg, #1a1a1a 0%, #333333 100%);
      color: white;
      border: none;
      border-radius: 12px;
      padding: 1rem 2rem;
      font-size: 1.1rem;
      font-weight: 600;
      text-transform: uppercase;
      letter-spacing: 0.5px;
      transition: all 0.3s ease;
      width: 100%;
      margin-bottom: 1.5rem;
    }

    .btn-reset:hover {
      background: linear-gradient(135deg, #000000 0%, #1a1a1a 100%);
      transform: translateY(-2px);
      box-shadow: 0 10px 30px rgba(26, 26, 26, 0.3);
      color: white;
    }

    .btn-reset:disabled {
      opacity: 0.7;
      transform: none;
      cursor: not-allowed;
    }

    .divider {
      text-align: center;
      margin: 1.5rem 0;
      position: relative;
    }

    .divider::before {
      content: '';
      position: absolute;
      top: 50%;
      left: 0;
      right: 0;
      height: 1px;
      background: #e9ecef;
    }

    .divider-text {
      background: rgba(255, 255, 255, 0.95);
      padding: 0 1rem;
      color: #666;
      font-size: 0.9rem;
      font-style: italic;
    }

    .action-links {
      text-align: center;
    }

    .action-link {
      display: block;
      color: #1a1a1a;
      text-decoration: none;
      font-weight: 500;
      margin-bottom: 0.75rem;
      transition: color 0.3s ease;
    }

    .action-link:hover {
      color: #000;
    }

    .action-link.primary {
      color: #1a1a1a;
      font-weight: 600;
    }

    .help-section {
      background: rgba(248, 249, 250, 0.8);
      border-radius: 12px;
      padding: 1.5rem;
      margin-top: 1.5rem;
      text-align: center;
      border: 1px solid #e9ecef;
    }

    .help-text {
      color: #666;
      font-size: 0.9rem;
      line-height: 1.5;
    }

    .help-text strong {
      color: #1a1a1a;
      font-weight: 600;
    }

    .footer {
      text-align: center;
      margin-top: 2rem;
      padding-top: 1.5rem;
      border-top: 1px solid #e9ecef;
    }

    .footer-text {
      color: #666;
      font-size: 0.85rem;
      font-style: italic;
    }

    .fade-in {
      animation: fadeIn 0.8s ease-out;
    }

    @keyframes fadeIn {
      from {
        opacity: 0;
        transform: translateY(30px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    @media (max-width: 768px) {
      .forgot-container {
        padding: 1rem;
      }

      .brand-title {
        font-size: 2rem;
      }

      .forgot-body {
        padding: 2rem 1.5rem;
      }

      .welcome-title {
        font-size: 1.25rem;
      }
    }

    @media (max-width: 480px) {
      .brand-header {
        padding: 2rem 1.5rem;
      }

      .brand-title {
        font-size: 1.75rem;
      }

      .forgot-body {
        padding: 1.5rem 1rem;
      }
    }
  </style>
</head>
<body>
  <div class="forgot-container">
    <div class="forgot-card fade-in">
      <!-- Brand Header -->
      <div class="brand-header">
        <h1 class="brand-title">vedge</h1>
        <p class="brand-subtitle">Fashion Forward Collection</p>
      </div>

      <!-- Forgot Password Body -->
      <div class="forgot-body">
        <!-- Welcome Text -->
        <div class="welcome-text">
          <div class="icon-wrapper">
            <i class="fas fa-key"></i>
          </div>
          <h2 class="welcome-title">Forgot Password?</h2>
          <p class="welcome-subtitle">No worries! Enter your email and we'll send you a reset link</p>
        </div>

        <!-- Alert Messages -->
        <div id="alert-container">
          <?php if (isset($_GET['pesan'])): ?>
            <div class="alert alert-info" role="alert">
              <i class="fas fa-info-circle me-2"></i><?= htmlspecialchars($_GET['pesan']) ?>
            </div>
          <?php endif; ?>
        </div>

        <!-- Forgot Password Form -->
        <form action="../vedge/proses/proses_lupa_password.php" method="POST" id="forgotPasswordForm">
          <!-- Email Input -->
          <div class="form-group">
            <label for="email" class="form-label">Email Address</label>
            <div class="input-wrapper">
              <div class="input-icon">
                <i class="fas fa-envelope"></i>
              </div>
              <input type="email" 
                     name="email" 
                     id="email"
                     class="form-control" 
                     placeholder="Enter your registered email"
                     required>
            </div>
            <div class="form-text">
              <i class="fas fa-info-circle"></i>Please ensure your email is registered with us
            </div>
          </div>

          <!-- Submit Button -->
          <button type="submit" class="btn btn-reset" id="submitBtn">
            <i class="fas fa-paper-plane me-2"></i>Send Reset Link
          </button>
        </form>

        <!-- Divider -->
        <div class="divider">
          <span class="divider-text">or</span>
        </div>

        <!-- Action Links -->
        <div class="action-links">
          <a href="login.php" class="action-link primary">
            <i class="fas fa-arrow-left me-2"></i>Back to <strong>Sign In</strong>
          </a>
        </div>

        <!-- Help Section -->
        <div class="help-section">
          <div class="help-text">
            <i class="fas fa-question-circle me-2"></i>
            <strong>Need help?</strong><br>
            Contact our customer service if you're having trouble resetting your password.
          </div>
        </div>

        <!-- Footer -->
        <div class="footer">
          <p class="footer-text">© 2025 vedge. All rights reserved.</p>
        </div>
      </div>
    </div>
  </div>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

  <!-- Custom JavaScript -->
  <script>
    // Form submission with loading state
    document.getElementById('forgotPasswordForm').addEventListener('submit', function(e) {
      const submitBtn = document.getElementById('submitBtn');
      const email = document.getElementById('email').value.trim();
      
      // Basic email validation
      const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      if (!emailRegex.test(email)) {
        e.preventDefault();
        showMessage('Please enter a valid email format!', 'danger');
        return false;
      }
      
      // Show loading state
      submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Sending...';
      submitBtn.disabled = true;
      
      // Re-enable button after 3 seconds (in case of error)
      setTimeout(function() {
        submitBtn.innerHTML = '<i class="fas fa-paper-plane me-2"></i>Send Reset Link';
        submitBtn.disabled = false;
      }, 3000);
    });

    // Function to show custom messages
    function showMessage(message, type = 'info') {
      const alertContainer = document.getElementById('alert-container');
      const alertHTML = `
        <div class="alert alert-${type}" role="alert">
          <i class="fas fa-${type === 'danger' ? 'exclamation-circle' : 'info-circle'} me-2"></i>${message}
        </div>
      `;
      alertContainer.innerHTML = alertHTML;
      
      // Auto dismiss after 5 seconds
      setTimeout(function() {
        const alert = alertContainer.querySelector('.alert');
        if (alert) {
          alert.style.opacity = '0';
          setTimeout(() => alert.remove(), 300);
        }
      }, 5000);
    }

    // Auto-focus on email input
    document.addEventListener('DOMContentLoaded', function() {
      document.getElementById('email').focus();
    });

    // Enter key submission
    document.getElementById('email').addEventListener('keypress', function(e) {
      if (e.key === 'Enter') {
        document.getElementById('forgotPasswordForm').dispatchEvent(new Event('submit'));
      }
    });
  </script>
</body>
</html>