<?php
session_start();
require 'config.php';
require './pelanggan/navbar.php';

$id = $_GET['id'] ?? null;

if (!isset($id) || !filter_var($id, FILTER_VALIDATE_INT)) {
  echo "Produk tidak ditemukan atau ID tidak valid.";
  exit;
}

// Ambil data produk
$stmt = $conn->prepare("
    SELECT p.*, kp.nama AS nama_kategori 
    FROM produk p 
    JOIN kategori_produk kp ON p.kategori_id = kp.id 
    WHERE p.id = ?
");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$produk = $result->fetch_assoc();

if (!$produk) {
  echo "Produk tidak ditemukan.";
  exit;
}

// Ambil semua ukuran produk dan stok-nya
$stmt_ukuran = $conn->prepare("SELECT id, ukuran, stok FROM ukuran_produk WHERE produk_id = ?");
$stmt_ukuran->bind_param("i", $id);
$stmt_ukuran->execute();
$result_ukuran = $stmt_ukuran->get_result();

$ukuran_list = [];
while ($row = $result_ukuran->fetch_assoc()) {
  $ukuran_list[] = $row;
}

$diskon = null;
if (!empty($produk['diskon_id'])) {
  $diskon_result = mysqli_query($conn, "SELECT * FROM diskon WHERE id = {$produk['diskon_id']} AND aktif = 'ya'");
  $diskon = mysqli_fetch_assoc($diskon_result);
}
?>

<!DOCTYPE html>
<html lang="id">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?= htmlspecialchars($produk['nama']) ?> - Day.Apparel</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
  <style>
    body {
      background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
      color: #1a1a1a;
      font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
      line-height: 1.6;
    }

    .product-hero {
      background: white;
      padding: 40px 0;
      margin-bottom: 40px;
      border-bottom: 1px solid #e9ecef;
    }

    .product-container {
      background: white;
      border-radius: 20px;
      box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
      overflow: hidden;
      margin-bottom: 40px;
    }

    .product-image-container {
      position: relative;
      background: #f8f9fa;
      border-radius: 20px 0 0 20px;
      overflow: hidden;
      min-height: 500px;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .product-image {
      width: 100%;
      height: 100%;
      object-fit: contain;
      max-height: 500px;
      transition: transform 0.3s ease;
    }

    .product-image:hover {
      transform: scale(1.05);
    }

    .product-details-container {
      padding: 40px;
      background: white;
    }

    .product-title {
      font-family: 'Playfair Display', serif;
      font-size: 2.2rem;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 15px;
      line-height: 1.2;
    }

    .product-category {
      display: inline-block;
      background: #f8f9fa;
      color: #1a1a1a;
      padding: 8px 16px;
      border-radius: 20px;
      font-size: 0.9rem;
      font-weight: 600;
      margin-bottom: 25px;
      border: 1px solid #e9ecef;
    }

    .product-description {
      color: #666;
      font-size: 1.05rem;
      line-height: 1.7;
      margin-bottom: 30px;
    }

    .price-section {
      background: #f8f9fa;
      padding: 25px;
      border-radius: 15px;
      margin-bottom: 30px;
      border: 1px solid #e9ecef;
    }

    .original-price {
      color: #999;
      text-decoration: line-through;
      font-size: 1.1rem;
      margin-bottom: 5px;
    }

    .discounted-price {
      color: #1a1a1a;
      font-size: 2rem;
      font-weight: 700;
      font-family: 'Playfair Display', serif;
    }

    .current-price {
      color: #1a1a1a;
      font-size: 2rem;
      font-weight: 700;
      font-family: 'Playfair Display', serif;
    }

    .discount-badge {
      background: linear-gradient(135deg, #1a1a1a 0%, #333 100%);
      color: white;
      padding: 8px 16px;
      border-radius: 20px;
      font-size: 0.9rem;
      font-weight: 600;
      display: inline-block;
      margin-bottom: 15px;
    }

    .size-section {
      margin-bottom: 30px;
    }

    .size-label {
      font-weight: 600;
      color: #1a1a1a;
      margin-bottom: 15px;
      font-size: 1.1rem;
    }

    .size-container {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(100px, 1fr));
      gap: 12px;
    }

    .size-card {
      background: white;
      border: 2px solid #e9ecef;
      border-radius: 12px;
      padding: 15px 10px;
      text-align: center;
      cursor: pointer;
      transition: all 0.3s ease;
      position: relative;
      overflow: hidden;
    }

    .size-card:hover:not(.disabled) {
      border-color: #1a1a1a;
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    }

    .size-card.active {
      background: #1a1a1a;
      color: white;
      border-color: #1a1a1a;
    }

    .size-card.disabled {
      background: #f8f9fa;
      color: #999;
      border-color: #e9ecef;
      cursor: not-allowed;
      opacity: 0.6;
    }

    .size-name {
      font-weight: 700;
      font-size: 1.1rem;
      margin-bottom: 5px;
    }

    .size-stock {
      font-size: 0.8rem;
      opacity: 0.8;
    }

    .quantity-section {
      margin-bottom: 30px;
    }

    .quantity-label {
      font-weight: 600;
      color: #1a1a1a;
      margin-bottom: 10px;
      font-size: 1.1rem;
    }

    .quantity-input {
      border: 2px solid #e9ecef;
      border-radius: 12px;
      padding: 15px;
      font-size: 1rem;
      width: 100%;
      transition: all 0.3s ease;
    }

    .quantity-input:focus {
      border-color: #1a1a1a;
      box-shadow: 0 0 0 3px rgba(26, 26, 26, 0.1);
      outline: none;
    }

    .stock-info {
      margin-top: 8px;
      font-size: 0.9rem;
      font-weight: 500;
    }

    .stock-info.success {
      color: #28a745;
    }

    .stock-info.danger {
      color: #dc3545;
    }

    .stock-info.muted {
      color: #6c757d;
    }

    .add-to-cart-btn {
      background: linear-gradient(135deg, #1a1a1a 0%, #333 100%);
      color: white;
      border: none;
      border-radius: 12px;
      padding: 18px 30px;
      font-size: 1.1rem;
      font-weight: 600;
      width: 100%;
      transition: all 0.3s ease;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 10px;
    }

    .add-to-cart-btn:hover:not(:disabled) {
      background: linear-gradient(135deg, #333 0%, #1a1a1a 100%);
      transform: translateY(-2px);
      box-shadow: 0 8px 25px rgba(26, 26, 26, 0.2);
      color: white;
    }

    .add-to-cart-btn:disabled {
      background: #e9ecef;
      color: #999;
      cursor: not-allowed;
      transform: none;
      box-shadow: none;
    }

    .login-alert {
      background: #f8f9fa;
      border: 1px solid #e9ecef;
      border-radius: 12px;
      padding: 20px;
      text-align: center;
      color: #666;
    }

    .login-alert a {
      color: #1a1a1a;
      font-weight: 600;
      text-decoration: none;
    }

    .login-alert a:hover {
      text-decoration: underline;
    }

    /* Reviews Section */
    .reviews-section {
      background: white;
      border-radius: 20px;
      box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
      padding: 40px;
      margin-bottom: 40px;
    }

    .reviews-header {
      text-align: center;
      margin-bottom: 40px;
    }

    .reviews-title {
      font-family: 'Playfair Display', serif;
      font-size: 2rem;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 10px;
    }

    .reviews-subtitle {
      color: #666;
      font-size: 1.1rem;
    }

    .review-card {
      background: #f8f9fa;
      border-radius: 15px;
      padding: 25px;
      margin-bottom: 20px;
      border: 1px solid #e9ecef;
      transition: transform 0.3s ease;
    }

    .review-card:hover {
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    }

    .review-header {
      display: flex;
      align-items: center;
      justify-content: space-between;
      margin-bottom: 15px;
      flex-wrap: wrap;
      gap: 10px;
    }

    .review-user {
      font-weight: 600;
      color: #1a1a1a;
      font-size: 1.1rem;
      display: flex;
      align-items: center;
      gap: 8px;
    }

    .review-date {
      color: #999;
      font-size: 0.9rem;
    }

    .review-rating {
      color: #ffc107;
      font-size: 1.2rem;
      margin-bottom: 15px;
    }

    .review-text {
      color: #666;
      font-size: 1rem;
      line-height: 1.6;
      margin: 0;
      font-style: italic;
    }

    .no-reviews {
      text-align: center;
      padding: 40px;
      color: #666;
    }

    /* Mobile Sticky Footer */
    .mobile-sticky-footer {
      position: fixed;
      bottom: 0;
      left: 0;
      right: 0;
      background: white;
      padding: 20px;
      box-shadow: 0 -5px 20px rgba(0, 0, 0, 0.1);
      z-index: 1000;
      border-top: 1px solid #e9ecef;
    }

    .mobile-sticky-footer .add-to-cart-btn {
      margin: 0;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
      .product-hero {
        padding: 20px 0;
      }

      .product-container {
        margin: 20px;
        border-radius: 15px;
      }

      .product-image-container {
        border-radius: 15px 15px 0 0;
        min-height: 300px;
      }

      .product-details-container {
        padding: 25px 20px;
      }

      .product-title {
        font-size: 1.8rem;
      }

      .price-section {
        padding: 20px;
      }

      .discounted-price,
      .current-price {
        font-size: 1.6rem;
      }

      .size-container {
        grid-template-columns: repeat(auto-fit, minmax(80px, 1fr));
        gap: 10px;
      }

      .size-card {
        padding: 12px 8px;
      }

      .size-name {
        font-size: 1rem;
      }

      .reviews-section {
        margin: 20px;
        padding: 25px 20px;
        border-radius: 15px;
      }

      .reviews-title {
        font-size: 1.6rem;
      }

      .review-card {
        padding: 20px;
      }

      .mobile-sticky-footer {
        padding: 15px;
      }

      .main-content {
        padding-bottom: 120px;
      }
    }

    @media (max-width: 480px) {
      .product-container {
        margin: 15px;
      }

      .product-details-container {
        padding: 20px 15px;
      }

      .product-title {
        font-size: 1.5rem;
      }

      .size-container {
        grid-template-columns: repeat(auto-fit, minmax(70px, 1fr));
        gap: 8px;
      }

      .size-card {
        padding: 10px 6px;
      }

      .size-name {
        font-size: 0.9rem;
      }

      .reviews-section {
        margin: 15px;
        padding: 20px 15px;
      }

      .reviews-title {
        font-size: 1.4rem;
      }

      .review-card {
        padding: 15px;
      }

      .main-content {
        padding-bottom: 100px;
      }
    }

    /* Animation */
    .product-container {
      animation: fadeInUp 0.6s ease-out;
    }

    @keyframes fadeInUp {
      from {
        opacity: 0;
        transform: translateY(30px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    /* Hide desktop submit button on mobile */
    @media (max-width: 768px) {
      .desktop-submit {
        display: none;
      }
    }

    @media (min-width: 769px) {
      .mobile-sticky-footer {
        display: none;
      }
    }
  </style>
</head>

<body>
  <!-- Product Hero Section -->
  <section class="product-hero">
    <div class="container">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb mb-0">
          <li class="breadcrumb-item"><a href="index.php" class="text-decoration-none">Home</a></li>
          <li class="breadcrumb-item"><a href="index.php" class="text-decoration-none">Produk</a></li>
          <li class="breadcrumb-item active" aria-current="page"><?= htmlspecialchars($produk['nama']) ?></li>
        </ol>
      </nav>
    </div>
  </section>

  <div class="container">
    <div class="product-container">
      <div class="row g-0">
        <div class="col-lg-6">
          <div class="product-image-container">
            <img src="upload/<?= htmlspecialchars($produk['gambar']) ?>" alt="<?= htmlspecialchars($produk['nama']) ?>" class="product-image">
          </div>
        </div>
        <div class="col-lg-6">
          <div class="product-details-container">
            <h1 class="product-title"><?= htmlspecialchars($produk['nama']) ?></h1>
            <div class="product-category">
              <i class="fas fa-tag me-2"></i><?= htmlspecialchars($produk['nama_kategori']) ?>
            </div>
            <p class="product-description"><?= nl2br(htmlspecialchars($produk['deskripsi'])) ?></p>

            <div class="price-section">
              <?php if ($diskon):
                $harga_diskon = $produk['harga'] - ($produk['harga'] * $diskon['persen'] / 100);
              ?>
                <div class="discount-badge">
                  <i class="fas fa-tag me-2"></i>Diskon <?= $diskon['persen'] ?>% OFF
                </div>
                <div class="original-price">Rp<?= number_format($produk['harga'], 0, ',', '.') ?></div>
                <div class="discounted-price">Rp<?= number_format($harga_diskon, 0, ',', '.') ?></div>
              <?php else: ?>
                <div class="current-price">Rp<?= number_format($produk['harga'], 0, ',', '.') ?></div>
              <?php endif; ?>
            </div>

            <form action="pelanggan/tambah_keranjang.php" method="POST">
              <input type="hidden" name="produk_id" value="<?= $produk['id'] ?>">
              <input type="hidden" id="ukuran" name="ukuran_id" required>

              <div class="size-section">
                <div class="size-label">
                  <i class="fas fa-ruler me-2"></i>Pilih Ukuran
                </div>
                <div class="size-container">
                  <?php foreach ($ukuran_list as $u): ?>
                    <div
                      id="ukuran-card-<?= $u['id'] ?>"
                      class="size-card <?= $u['stok'] <= 0 ? 'disabled' : '' ?>"
                      onclick="<?= $u['stok'] > 0 ? 'pilihUkuran(' . $u['id'] . ')' : '' ?>"
                      <?= $u['stok'] <= 0 ? 'title="Stok habis - tidak tersedia"' : '' ?>>
                      <div class="size-name"><?= htmlspecialchars($u['ukuran']) ?></div>
                      <div class="size-stock <?= $u['stok'] <= 0 ? 'text-danger' : 'text-muted' ?>">
                        <?= $u['stok'] <= 0 ? 'Stok Habis' : 'Stok: ' . $u['stok'] ?>
                      </div>
                    </div>
                  <?php endforeach; ?>
                </div>
              </div>

              <div class="quantity-section">
                <div class="quantity-label">
                  <i class="fas fa-shopping-cart me-2"></i>Jumlah
                </div>
                <input type="number" class="quantity-input" id="jumlah" name="jumlah" min="1" value="1" required>
                <div id="stokInfo" class="stock-info muted">Pilih ukuran untuk melihat stok</div>
              </div>

              <?php if (isset($_SESSION['user_id'])): ?>
                <button type="submit" class="add-to-cart-btn desktop-submit">
                  <i class="fas fa-shopping-cart"></i>
                  Tambah ke Keranjang
                </button>
              <?php else: ?>
                <div class="login-alert">
                  <i class="fas fa-info-circle me-2"></i>
                  Silakan <a href="login.php">login</a> terlebih dahulu untuk membeli produk.
                </div>
              <?php endif; ?>
            </form>
          </div>
        </div>
      </div>
    </div>

    <!-- Reviews Section -->
    <div class="reviews-section">
      <div class="reviews-header">
        <h2 class="reviews-title">Ulasan Produk</h2>
        <p class="reviews-subtitle">Apa kata pelanggan tentang produk ini</p>
      </div>

      <div class="reviews-container">
        <?php
        // Tampilkan review yang sudah di-approve
        $stmt_ulasan = $conn->prepare("SELECT up.*, p.nama as nama_pengguna FROM ulasan_produk up JOIN pengguna p ON up.id_pelanggan = p.id WHERE up.id_produk = ? AND up.status = 'approved' ORDER BY up.tanggal_ulasan DESC");
        if ($stmt_ulasan) {
          $stmt_ulasan->bind_param("i", $id);
          $stmt_ulasan->execute();
          $result_ulasan = $stmt_ulasan->get_result();
        } else {
          echo "Error preparing statement: " . $conn->error;
          $result_ulasan = null;
        }
        
        if ($result_ulasan && $result_ulasan->num_rows > 0):
          while ($ulasan = $result_ulasan->fetch_assoc()):
        ?>
          <div class="review-card">
            <div class="review-header">
              <div class="review-user">
                <i class="fas fa-user-circle"></i>
                <?= htmlspecialchars($ulasan['nama_pengguna']) ?>
              </div>
              <div class="review-date">
                <i class="fas fa-clock me-1"></i>
                <?= date('d M Y H:i', strtotime($ulasan['tanggal_ulasan'])) ?>
              </div>
            </div>
            <div class="review-rating">
              <?php for ($i = 1; $i <= 5; $i++): ?>
                <?php if ($i <= $ulasan['rating']): ?>
                  <i class="fas fa-star"></i>
                <?php else: ?>
                  <i class="far fa-star"></i>
                <?php endif; ?>
              <?php endfor; ?>
            </div>
            <p class="review-text">"<?= nl2br(htmlspecialchars($ulasan['isi_ulasan'])) ?>"</p>
          </div>
        <?php endwhile;
        else: ?>
          <div class="no-reviews">
            <i class="fas fa-comments fa-3x mb-3 text-muted"></i>
            <p>Belum ada ulasan untuk produk ini.</p>
            <small class="text-muted">Jadilah yang pertama memberikan ulasan!</small>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <!-- Mobile Sticky Footer -->
  <?php if (isset($_SESSION['user_id'])): ?>
    <div class="mobile-sticky-footer">
      <form action="pelanggan/tambah_keranjang.php" method="POST">
        <input type="hidden" name="produk_id" value="<?= $produk['id'] ?>">
        <input type="hidden" id="ukuran-mobile" name="ukuran_id" required>
        <input type="hidden" id="jumlah-mobile" name="jumlah" value="1" required>
        <button type="submit" class="add-to-cart-btn">
          <i class="fas fa-shopping-cart"></i>
          Tambah ke Keranjang
        </button>
      </form>
    </div>
  <?php endif; ?>

  <?php include 'footer.php'; ?>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

  <script>
    const ukuranData = <?= json_encode($ukuran_list) ?>;

    function pilihUkuran(id) {
      // Cek apakah ukuran ini tersedia (stok > 0)
      const ukuranTerpilih = ukuranData.find(u => u.id == id);
      if (!ukuranTerpilih || ukuranTerpilih.stok <= 0) {
        alert('Maaf, ukuran ini sedang tidak tersedia (stok habis)');
        return;
      }

      document.getElementById('ukuran').value = id;
      document.getElementById('ukuran-mobile').value = id;
      updateJumlahMax();
      document.querySelectorAll('.size-card').forEach(el => el.classList.remove('active'));
      document.getElementById('ukuran-card-' + id).classList.add('active');
    }

    function updateJumlahMax() {
      const selectedUkuranId = document.getElementById('ukuran').value;
      const jumlahInput = document.getElementById('jumlah');
      const jumlahInputMobile = document.getElementById('jumlah-mobile');
      const submitBtn = document.querySelector('button[type="submit"]');
      const submitBtnMobile = document.querySelector('.mobile-sticky-footer button[type="submit"]');
      const ukuranTerpilih = ukuranData.find(u => u.id == selectedUkuranId);

      if (ukuranTerpilih && ukuranTerpilih.stok > 0) {
        jumlahInput.max = ukuranTerpilih.stok;
        jumlahInput.value = Math.min(jumlahInput.value || 1, ukuranTerpilih.stok);
        jumlahInput.disabled = false;
        jumlahInput.min = 1;
        if (jumlahInputMobile) {
          jumlahInputMobile.max = ukuranTerpilih.stok;
          jumlahInputMobile.value = jumlahInput.value;
          jumlahInputMobile.disabled = false;
          jumlahInputMobile.min = 1;
        }
        if (submitBtn) submitBtn.disabled = false;
        if (submitBtnMobile) submitBtnMobile.disabled = false;
        document.getElementById('stokInfo').innerText = `Stok tersedia: ${ukuranTerpilih.stok}`;
        document.getElementById('stokInfo').className = 'stock-info success';
      } else if (ukuranTerpilih && ukuranTerpilih.stok === 0) {
        jumlahInput.max = 0;
        jumlahInput.value = 0;
        jumlahInput.disabled = true;
        if (jumlahInputMobile) {
          jumlahInputMobile.max = 0;
          jumlahInputMobile.value = 0;
          jumlahInputMobile.disabled = true;
        }
        if (submitBtn) submitBtn.disabled = true;
        if (submitBtnMobile) submitBtnMobile.disabled = true;
        document.getElementById('stokInfo').innerText = `Stok habis - tidak tersedia`;
        document.getElementById('stokInfo').className = 'stock-info danger';
      } else {
        jumlahInput.max = 0;
        jumlahInput.value = 0;
        jumlahInput.disabled = true;
        if (jumlahInputMobile) {
          jumlahInputMobile.max = 0;
          jumlahInputMobile.value = 0;
          jumlahInputMobile.disabled = true;
        }
        if (submitBtn) submitBtn.disabled = true;
        if (submitBtnMobile) submitBtnMobile.disabled = true;
        document.getElementById('stokInfo').innerText = `Pilih ukuran terlebih dahulu`;
        document.getElementById('stokInfo').className = 'stock-info muted';
      }
    }

    // Validasi saat input jumlah berubah
    function validateJumlah() {
      const jumlahInput = document.getElementById('jumlah');
      const jumlahInputMobile = document.getElementById('jumlah-mobile');
      const selectedUkuranId = document.getElementById('ukuran').value;
      const ukuranTerpilih = ukuranData.find(u => u.id == selectedUkuranId);

      if (ukuranTerpilih) {
        if (parseInt(jumlahInput.value) > ukuranTerpilih.stok) {
          jumlahInput.value = ukuranTerpilih.stok;
        }
        if (parseInt(jumlahInput.value) < 1) {
          jumlahInput.value = 1;
        }
        // Sync mobile input
        if (jumlahInputMobile) {
          jumlahInputMobile.value = jumlahInput.value;
        }
      }
    }

    function validateJumlahMobile() {
      const jumlahInput = document.getElementById('jumlah');
      const jumlahInputMobile = document.getElementById('jumlah-mobile');
      const selectedUkuranId = document.getElementById('ukuran').value;
      const ukuranTerpilih = ukuranData.find(u => u.id == selectedUkuranId);
      
      if (ukuranTerpilih) {
        if (parseInt(jumlahInputMobile.value) > ukuranTerpilih.stok) {
          jumlahInputMobile.value = ukuranTerpilih.stok;
        }
        if (parseInt(jumlahInputMobile.value) < 1) {
          jumlahInputMobile.value = 1;
        }
        
        // Sync desktop input
        jumlahInput.value = jumlahInputMobile.value;
      }
    }

    document.addEventListener('DOMContentLoaded', function() {
      updateJumlahMax();

      // Add event listener untuk input jumlah
      const jumlahInput = document.getElementById('jumlah');
      const jumlahInputMobile = document.getElementById('jumlah-mobile');
      if (jumlahInput) {
        jumlahInput.addEventListener('input', validateJumlah);
        jumlahInput.addEventListener('change', validateJumlah);
      }
      if (jumlahInputMobile) {
        jumlahInputMobile.addEventListener('input', validateJumlahMobile);
        jumlahInputMobile.addEventListener('change', validateJumlahMobile);
      }

      // Disable submit button initially
      const submitBtn = document.querySelector('button[type="submit"]');
      const submitBtnMobile = document.querySelector('.mobile-sticky-footer button[type="submit"]');
      if (submitBtn) submitBtn.disabled = true;
      if (submitBtnMobile) submitBtnMobile.disabled = true;
    });
  </script>
</body>

</html>