<?php
if (session_status() == PHP_SESSION_NONE) {
  session_start();
}
require '../../config.php';

// Handle tambah/edit diskon
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $id = isset($_POST['id']) ? intval($_POST['id']) : 0;
  $nama = mysqli_real_escape_string($conn, $_POST['nama_diskon']);
  $persen = intval($_POST['persen']);
  $aktif = $_POST['aktif'];
  if ($id) {
    // Edit
    $stmt = $conn->prepare("UPDATE diskon SET nama_diskon=?, persen=?, aktif=? WHERE id=?");
    $stmt->bind_param("sisi", $nama, $persen, $aktif, $id);
    $stmt->execute();
    $_SESSION['alert'] = 'Diskon berhasil diupdate!';
  } else {
    // Tambah
    $stmt = $conn->prepare("INSERT INTO diskon (nama_diskon, persen, aktif) VALUES (?, ?, ?)");
    $stmt->bind_param("sis", $nama, $persen, $aktif);
    $stmt->execute();
    $_SESSION['alert'] = 'Diskon berhasil ditambahkan!';
  }
  header('Location: daftar_diskon.php');
  exit;
}
// Handle hapus diskon
if (isset($_GET['hapus']) && is_numeric($_GET['hapus'])) {
  $id = intval($_GET['hapus']);
  $stmt = $conn->prepare("DELETE FROM diskon WHERE id=?");
  $stmt->bind_param("i", $id);
  $stmt->execute();
  $_SESSION['alert'] = 'Diskon berhasil dihapus!';
  header('Location: daftar_diskon.php');
  exit;
}
// Ambil semua diskon
$result = $conn->query("SELECT * FROM diskon ORDER BY id DESC");
?>
<!DOCTYPE html>
<html lang="id">

<head>
  <meta charset="UTF-8">
  <title>List Diskon</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body {
      background-color: #f4f7f6;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      color: #333;
    }

    .main-header {
      font-size: 2.2rem;
      font-weight: 700;
      color: #2c3e50;
      margin-bottom: 25px;
      padding-bottom: 15px;
      border-bottom: 2px solid #eee;
      text-align: center;
    }

    .table {
      background-color: #fff;
      border-radius: 10px;
      overflow: hidden;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.03);
      margin-top: 20px;
    }

    .table thead th {
      background-color: #ecf0f1;
      color: #555;
      font-weight: 600;
      border-bottom: 1px solid #dee2e6;
      padding: 12px 15px;
      text-transform: uppercase;
      font-size: 0.9em;
    }

    .table tbody tr:hover {
      background-color: #f9f9f9;
    }

    .table td {
      padding: 12px 15px;
      vertical-align: middle;
      font-size: 0.95em;
    }

    .badge-aktif {
      background: #2ecc71;
      color: #fff;
      font-weight: 600;
      border-radius: .4rem;
      padding: .4em .7em;
      font-size: .8em;
      letter-spacing: 0.5px;
    }

    .badge-tidak {
      background: #6c757d;
      color: #fff;
      font-weight: 600;
      border-radius: .4rem;
      padding: .4em .7em;
      font-size: .8em;
      letter-spacing: 0.5px;
    }

    .aksi-btns {
      display: flex;
      gap: 8px;
    }

    .btn-primary {
      background-color: #34495e;
      border-color: #34495e;
      transition: all 0.3s ease;
      font-weight: 600;
      padding: 10px 20px;
      border-radius: 8px;
    }

    .btn-primary:hover {
      background-color: #2c3e50;
      border-color: #2c3e50;
      transform: translateY(-2px);
      box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
    }

    .btn-warning {
      border-radius: 8px;
      font-weight: 600;
    }

    .btn-danger {
      border-radius: 8px;
      font-weight: 600;
    }

    .btn-sm {
      padding: .3rem .75rem;
      font-size: .875rem;
      border-radius: .4rem;
    }

    .alert {
      border-radius: 8px;
      font-size: 1.05em;
      padding: 15px 20px;
      margin-bottom: 25px;
    }

    .alert-success {
      background-color: #d4edda;
      color: #155724;
      border-color: #c3e6cb;
    }

    .btn-close {
      font-size: 0.9em;
    }

    .btn-edit,
    .btn-hapus {
      background: transparent !important;
      border: none !important;
      color: #222 !important;
      font-weight: 600;
      box-shadow: none !important;
      display: inline-flex;
      align-items: center;
      gap: 4px;
    }

    .btn-edit i,
    .btn-hapus i {
      color: #222 !important;
    }

    @media (max-width: 900px) {
      .table-responsive {
        font-size: 0.97rem;
      }
    }
  </style>
</head>

<body>
  <?php require '../sidebar.php'; ?>
  <div class="container-fluid">
    <div class="card" style="border-radius:16px;box-shadow:0 4px 20px rgba(0,0,0,0.05);background:#fff;width:100%;max-width:100%;padding:32px 24px 24px 24px;margin-top:32px;">
      <h3 class="main-header">List Diskon</h3>
      <?php if (isset($_SESSION['alert'])): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert" id="notif-alert">
          <?= htmlspecialchars($_SESSION['alert']) ?>
          <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php unset($_SESSION['alert']); ?>
      <?php endif; ?>
      <button class="btn btn-primary mb-3" style="background-color:#34495e;border-color:#34495e;transition:all 0.3s;font-weight:600;padding:10px 20px;border-radius:8px;" data-bs-toggle="modal" data-bs-target="#modalTambah"><i class="bi bi-plus-circle"></i> Tambah Diskon</button>
      <div class="table-responsive">
        <table class="table table-hover">
          <thead>
            <tr>
              <th style="width:40px">No</th>
              <th>Nama Diskon</th>
              <th>Persen</th>
              <th>Status</th>
              <th style="width:120px">Aksi</th>
            </tr>
          </thead>
          <tbody>
            <?php $no = 1;
            while ($row = $result->fetch_assoc()): ?>
              <tr>
                <td><?= $no++ ?></td>
                <td><?= htmlspecialchars($row['nama_diskon']) ?></td>
                <td><?= htmlspecialchars($row['persen']) ?>%</td>
                <td>
                  <?php if ($row['aktif'] === 'ya'): ?>
                    <span class="badge badge-aktif">Aktif</span>
                  <?php else: ?>
                    <span class="badge badge-tidak">Tidak Aktif</span>
                  <?php endif; ?>
                </td>
                <td>
                  <div class="aksi-btns">
                    <button class="btn btn-edit btn-sm" data-bs-toggle="modal" data-bs-target="#modalEdit<?= $row['id'] ?>"><i class="bi bi-pencil"></i> Edit</button>
                    <a href="?hapus=<?= $row['id'] ?>" class="btn btn-hapus btn-sm" onclick="return confirm('Yakin hapus diskon?')"><i class="bi bi-trash"></i> Hapus</a>
                  </div>
                  <!-- Modal Edit -->
                  <div class="modal fade" id="modalEdit<?= $row['id'] ?>" tabindex="-1" aria-labelledby="modalEditLabel<?= $row['id'] ?>" aria-hidden="true">
                    <div class="modal-dialog">
                      <form class="modal-content" method="POST">
                        <input type="hidden" name="id" value="<?= $row['id'] ?>">
                        <div class="modal-header">
                          <h5 class="modal-title" id="modalEditLabel<?= $row['id'] ?>">Edit Diskon</h5>
                          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                          <div class="mb-3">
                            <label for="nama_diskon_edit_<?= $row['id'] ?>" class="form-label">Nama Diskon</label>
                            <input type="text" name="nama_diskon" id="nama_diskon_edit_<?= $row['id'] ?>" class="form-control" value="<?= htmlspecialchars($row['nama_diskon']) ?>" required>
                          </div>
                          <div class="mb-3">
                            <label for="persen_edit_<?= $row['id'] ?>" class="form-label">Persen (%)</label>
                            <input type="number" name="persen" id="persen_edit_<?= $row['id'] ?>" class="form-control" value="<?= htmlspecialchars($row['persen']) ?>" min="0" max="100" required>
                          </div>
                          <div class="mb-3">
                            <label for="aktif_edit_<?= $row['id'] ?>" class="form-label">Status</label>
                            <select name="aktif" id="aktif_edit_<?= $row['id'] ?>" class="form-select" required>
                              <option value="ya" <?= $row['aktif'] === 'ya' ? 'selected' : '' ?>>Aktif</option>
                              <option value="tidak" <?= $row['aktif'] === 'tidak' ? 'selected' : '' ?>>Tidak Aktif</option>
                            </select>
                          </div>
                        </div>
                        <div class="modal-footer">
                          <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Batal</button>
                          <button class="btn btn-primary" type="submit"><i class="bi bi-save"></i> Simpan</button>
                        </div>
                      </form>
                    </div>
                  </div>
                </td>
              </tr>
            <?php endwhile; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
  <!-- Modal Tambah -->
  <div class="modal fade" id="modalTambah" tabindex="-1" aria-labelledby="modalTambahLabel" aria-hidden="true">
    <div class="modal-dialog">
      <form class="modal-content" method="POST">
        <div class="modal-header">
          <h5 class="modal-title" id="modalTambahLabel">Tambah Diskon</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <div class="mb-3">
            <label for="nama_diskon" class="form-label">Nama Diskon</label>
            <input type="text" name="nama_diskon" id="nama_diskon" class="form-control" required>
          </div>
          <div class="mb-3">
            <label for="persen" class="form-label">Persen (%)</label>
            <input type="number" name="persen" id="persen" class="form-control" min="0" max="100" required>
          </div>
          <div class="mb-3">
            <label for="aktif" class="form-label">Status</label>
            <select name="aktif" id="aktif" class="form-select" required>
              <option value="ya">Aktif</option>
              <option value="tidak">Tidak Aktif</option>
            </select>
          </div>
        </div>
        <div class="modal-footer">
          <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Batal</button>
          <button class="btn btn-primary" type="submit"><i class="bi bi-save"></i> Simpan</button>
        </div>
      </form>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    setTimeout(function() {
      var notif = document.getElementById('notif-alert');
      if (notif) {
        notif.style.transition = 'opacity 0.5s';
        notif.style.opacity = 0;
        setTimeout(function() {
          notif.remove();
        }, 500);
      }
    }, 2000);
  </script>
</body>

</html>