<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
require '../config.php';
require 'sidebar.php'; // Ensure this path is correct based on your file structure

// Get transaction ID from URL
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($id === 0) {
    // Redirect or show error if ID is not provided
    header("Location: cek_pesanan.php");
    exit;
}

// --- Fetch Transaction Data (Using Prepared Statements for Security) ---
$stmt_transaksi = $conn->prepare("
    SELECT t.*, u.nama AS nama_pelanggan, u.alamat_lengkap , u.provinsi, u.kabupaten_kota,u.kecamatan,u.kelurahan
    FROM transaksi t
    JOIN pengguna u ON t.pengguna_id = u.id
    WHERE t.id = ?
");
if ($stmt_transaksi === false) {
    die("Prepare failed: " . $conn->error);
}
$stmt_transaksi->bind_param("i", $id);
$stmt_transaksi->execute();
$result_transaksi = $stmt_transaksi->get_result();
$transaksi = $result_transaksi->fetch_assoc();
$stmt_transaksi->close();

// Redirect if transaction not found
if (!$transaksi) {
    $_SESSION['alert'] = ['type' => 'danger', 'message' => 'Detail pesanan tidak ditemukan.'];
    header("Location: cek_pesanan.php");
    exit;
}

// --- Fetch Transaction Details (Using Prepared Statements for Security) ---
$stmt_detail = $conn->prepare("
    SELECT td.*, p.nama AS nama_produk, p.harga, up.ukuran
    FROM transaksi_detail td
    JOIN produk p ON td.produk_id = p.id
    JOIN ukuran_produk up ON td.ukuran_id = up.id
    WHERE td.transaksi_id = ?
");
if ($stmt_detail === false) {
    die("Prepare failed: " . $conn->error);
}
$stmt_detail->bind_param("i", $id);
$stmt_detail->execute();
$detail = $stmt_detail->get_result();
$stmt_detail->close();

// Function to format transaction code
function formatKodeTransaksi($id, $timestamp)
{
    $tanggal = date('Ymd', strtotime($timestamp));
    return 'TRX-' . $tanggal . '-' . str_pad($id, 4, '0', STR_PAD_LEFT);
}
?>

<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Pesanan - Admin Day Apparel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f4f7f6;
            /* Light gray background */
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #333;
        }

        /* Content wrapper styles from other admin pages */
        #page-content-wrapper {
            flex-grow: 1;
            padding: 30px;
            background-color: #ffffff;
            /* White content background */
            border-radius: 12px;
            /* Softly rounded corners */
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.05);
            /* Subtle shadow */
            margin: 20px;
            /* Margin around the content area */
        }

        .main-header {
            font-size: 2.2rem;
            font-weight: 700;
            color: #2c3e50;
            /* Darker title color */
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 2px solid #eee;
            /* Subtle separator */
            text-align: center;
        }

        /* Table Styling */
        .table {
            background-color: #fff;
            border-radius: 10px;
            /* Rounded table corners */
            overflow: hidden;
            /* Ensures radius applies */
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.03);
            /* Very light table shadow */
            margin-top: 20px;
        }

        .table thead th {
            background-color: #ecf0f1;
            /* Light header background */
            color: #555;
            font-weight: 600;
            border-bottom: 1px solid #dee2e6;
            padding: 12px 15px;
            text-transform: uppercase;
            font-size: 0.9em;
        }

        .table tbody tr:hover {
            background-color: #f9f9f9;
            /* Subtle hover effect */
        }

        .table td {
            padding: 12px 15px;
            vertical-align: middle;
            font-size: 0.95em;
        }

        /* Info boxes */
        .info-box {
            background-color: #f8f9fa;
            border: 1px solid #e9ecef;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.02);
        }

        .info-box strong {
            color: #2c3e50;
        }

        /* Status Badges */
        .status-badge {
            display: inline-block;
            padding: .4em .7em;
            font-size: .8em;
            font-weight: 600;
            line-height: 1;
            color: #fff;
            text-align: center;
            white-space: nowrap;
            vertical-align: middle;
            border-radius: .4rem;
            text-transform: capitalize;
            /* Capitalize first letter */
        }

        .status-menunggu {
            background-color: #f39c12;
        }

        /* Orange */
        .status-dibayar {
            background-color: #2ecc71;
        }

        /* Green */
        .status-dikirim {
            background-color: #3498db;
        }

        /* Blue */
        .status-selesai {
            background-color: #1abc9c;
        }

        /* Turquoise */
        .status-dibatalkan {
            background-color: #e74c3c;
        }

        /* Red */


        /* Image styling */
        .bukti-pembayaran-img {
            max-width: 100%;
            /* Responsive image */
            height: auto;
            border-radius: 8px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
            margin-top: 15px;
            border: 1px solid #eee;
        }

        /* Button Styling */
        .btn-primary {
            background-color: #34495e;
            /* Darker blue/gray primary */
            border-color: #34495e;
            transition: all 0.3s ease;
            font-weight: 600;
            padding: 10px 20px;
            border-radius: 8px;
            /* Rounded buttons */
        }

        .btn-primary:hover {
            background-color: #2c3e50;
            border-color: #2c3e50;
            transform: translateY(-2px);
            /* Slight lift on hover */
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }

        .btn-secondary {
            background-color: #bdc3c7;
            /* Light gray for secondary actions */
            border-color: #bdc3c7;
            color: #fff;
            font-weight: 500;
            border-radius: 8px;
            padding: 10px 20px;
            transition: all 0.3s ease;
        }

        .btn-secondary:hover {
            background-color: #95a5a6;
            border-color: #95a5a6;
            transform: translateY(-2px);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>

<body>
    <div id="wrapper">
        <?php // The sidebar.php content is included here 
        ?>
        <div id="page-content-wrapper">
            <div class="container-fluid">
                <h2 class="main-header">Detail Transaksi <br><small class="text-muted fw-normal"><?= formatKodeTransaksi($transaksi['id'], $transaksi['dibuat_pada']) ?></small></h2>

                <div class="info-box">
                    <p><strong>Pelanggan:</strong> <?= htmlspecialchars($transaksi['nama_pelanggan']) ?></p>
                    <p><strong>Total Bayar:</strong> Rp<?= number_format($transaksi['total_harga'], 0, ',', '.') ?></p>
                    <p>
                        <strong>Status:</strong>
                        <span class="status-badge status-<?= htmlspecialchars($transaksi['status']) ?>">
                            <?= htmlspecialchars(ucwords(str_replace('_', ' ', $transaksi['status']))) ?>
                        </span>
                    </p>
                    <p>
                        <strong>Nomor Resi:</strong>
                        <?= $transaksi['resi'] ? htmlspecialchars($transaksi['resi']) : 'Nomor Resi belum diterbitkan' ?>
                    </p>
                    <p><strong>Tanggal Pesan:</strong> <?= htmlspecialchars($transaksi['dibuat_pada']) ?></p>
                    <p><strong>Alamat Pengiriman:</strong> <?= htmlspecialchars($transaksi['alamat_lengkap']) ?></p>
                    <p><strong>Provinsi:</strong> <?= htmlspecialchars($transaksi['provinsi']) ?></p>
                    <p><strong>kabupaten/kota:</strong> <?= htmlspecialchars($transaksi['kabupaten_kota']) ?></p>
                    <p><strong>Kecamatan:</strong> <?= htmlspecialchars($transaksi['kecamatan']) ?></p>
                    <p><strong>Kelurahan:</strong> <?= htmlspecialchars($transaksi['kelurahan']) ?></p>
                    <p><strong>Metode Pembayaran:</strong> <?= htmlspecialchars($transaksi['metode_pembayaran']) ?></p>
                </div>

                <h4>Produk dalam Pesanan:</h4>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Produk</th>
                                <th>Ukuran</th>
                                <th>Jumlah</th>
                                <th>Subtotal</th>
                                <th>Total Bayar</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if ($detail->num_rows > 0): ?>
                                <?php while ($d = $detail->fetch_assoc()) : ?>
                                    <tr>
                                        <td><?= htmlspecialchars($d['nama_produk']) ?></td>
                                        <td><?= htmlspecialchars($d['ukuran']) ?></td>
                                        <td><?= htmlspecialchars($d['jumlah']) ?></td>
                                        <td>Rp<?= number_format($d['subtotal'], 0, ',', '.') ?></td>
                                        <td>Rp<?= number_format($transaksi['total_harga'], 0, ',', '.') ?></td>
                                    </tr>
                                <?php endwhile; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="4" class="text-center py-3 text-muted">Tidak ada detail produk untuk pesanan ini.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="4" class="text-end fw-bold">Ongkos Kirim:</td>
                                <td class="fw-bold">Rp<?= number_format($transaksi['ongkos_kirim'], 0, ',', '.') ?></td>
                            </tr>
                            <tr>
                                <td colspan="4" class="text-end fw-bold fs-5">Total Keseluruhan:</td>
                                <td class="fw-bold fs-5 text-primary">Rp<?= number_format($transaksi['total_harga']) ?></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <?php if ($transaksi['bukti_pembayaran']) : ?>
                    <div class="info-box mt-4">
                        <p class="mb-2"><strong>Bukti Pembayaran:</strong></p>
                        <a href="../upload/<?= htmlspecialchars($transaksi['bukti_pembayaran']) ?>" target="_blank">
                            <img src="../upload/<?= htmlspecialchars($transaksi['bukti_pembayaran']) ?>" alt="Bukti Pembayaran" class="bukti-pembayaran-img">
                        </a>
                    </div>
                <?php endif; ?>

                <div class="mt-4 d-flex justify-content-start gap-2">
                    <a href="cetak_invoice.php?id=<?= htmlspecialchars($id) ?>" class="btn btn-primary" target="_blank">
                        <i class="fas fa-print me-2"></i> Cetak Invoice
                    </a>
                    <a href="cek_pesanan.php" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i> Kembali ke Daftar Pesanan
                    </a>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>